/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class FieldNestedUpdateAgg
extends FieldAggregator {
    public static final String NAME = "nested_update";
    private final int nestedFields;
    @Nullable
    private final Projection keyProjection;
    @Nullable
    private final RecordEqualiser elementEqualiser;

    public FieldNestedUpdateAgg(ArrayType dataType, List<String> nestedKey) {
        super((DataType)dataType);
        RowType nestedType = (RowType)dataType.getElementType();
        this.nestedFields = nestedType.getFieldCount();
        if (nestedKey.isEmpty()) {
            this.keyProjection = null;
            this.elementEqualiser = CodeGenUtils.newRecordEqualiser(nestedType.getFieldTypes());
        } else {
            this.keyProjection = CodeGenUtils.newProjection(nestedType, nestedKey);
            this.elementEqualiser = null;
        }
    }

    @Override
    String name() {
        return NAME;
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        int i;
        if (accumulator == null || inputField == null) {
            return accumulator == null ? inputField : accumulator;
        }
        InternalArray acc = (InternalArray)accumulator;
        InternalArray input = (InternalArray)inputField;
        ArrayList<Object> rows = new ArrayList<InternalRow>();
        for (i = 0; i < acc.size(); ++i) {
            rows.add(acc.getRow(i, this.nestedFields));
        }
        for (i = 0; i < input.size(); ++i) {
            rows.add(input.getRow(i, this.nestedFields));
        }
        if (this.keyProjection != null) {
            HashMap<BinaryRow, InternalRow> map = new HashMap<BinaryRow, InternalRow>();
            for (InternalRow row : rows) {
                BinaryRow key = this.keyProjection.apply(row).copy();
                map.put(key, row);
            }
            rows = new ArrayList(map.values());
        }
        return new GenericArray(rows.toArray());
    }

    @Override
    public Object retract(Object accumulator, Object retractField) {
        int i;
        if (accumulator == null || retractField == null) {
            return accumulator;
        }
        InternalArray acc = (InternalArray)accumulator;
        InternalArray retract = (InternalArray)retractField;
        if (this.keyProjection == null) {
            int i2;
            Preconditions.checkNotNull((Object)this.elementEqualiser);
            ArrayList<InternalRow> rows = new ArrayList<InternalRow>();
            for (i2 = 0; i2 < acc.size(); ++i2) {
                rows.add(acc.getRow(i2, this.nestedFields));
            }
            for (i2 = 0; i2 < retract.size(); ++i2) {
                InternalRow retractRow = retract.getRow(i2, this.nestedFields);
                rows.removeIf(next -> this.elementEqualiser.equals(next, retractRow));
            }
            return new GenericArray(rows.toArray());
        }
        HashMap<BinaryRow, InternalRow> map = new HashMap<BinaryRow, InternalRow>();
        for (i = 0; i < acc.size(); ++i) {
            InternalRow row = acc.getRow(i, this.nestedFields);
            map.put(this.keyProjection.apply(row).copy(), row);
        }
        for (i = 0; i < retract.size(); ++i) {
            map.remove(this.keyProjection.apply(retract.getRow(i, this.nestedFields)));
        }
        return new GenericArray(new ArrayList(map.values()).toArray());
    }
}

