/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.StringUtils;

public class RowDataPartitionComputer {
    protected final String defaultPartValue;
    protected final String[] partitionColumns;
    protected final InternalRow.FieldGetter[] partitionFieldGetters;

    public RowDataPartitionComputer(String defaultPartValue, RowType rowType, String[] partitionColumns) {
        this.defaultPartValue = defaultPartValue;
        this.partitionColumns = partitionColumns;
        List columnList = rowType.getFieldNames();
        this.partitionFieldGetters = (InternalRow.FieldGetter[])Arrays.stream(partitionColumns).mapToInt(columnList::indexOf).mapToObj(i -> InternalRowUtils.createNullCheckingFieldGetter((DataType)rowType.getTypeAt(i), (int)i)).toArray(InternalRow.FieldGetter[]::new);
    }

    public LinkedHashMap<String, String> generatePartValues(InternalRow in) {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionFieldGetters.length; ++i) {
            String partitionValue;
            Object field = this.partitionFieldGetters[i].getFieldOrNull(in);
            String string = partitionValue = field != null ? field.toString() : null;
            if (StringUtils.isNullOrWhitespaceOnly((String)partitionValue)) {
                partitionValue = this.defaultPartValue;
            }
            partSpec.put(this.partitionColumns[i], partitionValue);
        }
        return partSpec;
    }
}

