/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.format.avro.AvroSchemaConverter;
import org.apache.paimon.format.avro.JodaConverter;
import org.apache.paimon.shade.org.apache.avro.generic.GenericFixed;
import org.apache.paimon.shade.org.apache.avro.generic.IndexedRecord;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;

public class AvroToRowDataConverters {
    public static AvroToRowDataConverter createRowConverter(RowType rowType) {
        AvroToRowDataConverter[] fieldConverters = (AvroToRowDataConverter[])rowType.getFields().stream().map(DataField::type).map(AvroToRowDataConverters::createNullableConverter).toArray(AvroToRowDataConverter[]::new);
        int arity = rowType.getFieldCount();
        return avroObject -> {
            IndexedRecord record = (IndexedRecord)avroObject;
            GenericRow row = new GenericRow(arity);
            for (int i = 0; i < arity; ++i) {
                row.setField(i, fieldConverters[i].convert(record.get(i)));
            }
            return row;
        };
    }

    private static AvroToRowDataConverter createNullableConverter(DataType type) {
        AvroToRowDataConverter converter = AvroToRowDataConverters.createConverter(type);
        return avroObject -> {
            if (avroObject == null) {
                return null;
            }
            return converter.convert(avroObject);
        };
    }

    @VisibleForTesting
    static AvroToRowDataConverter createConverter(DataType type) {
        switch (type.getTypeRoot()) {
            case TINYINT: {
                return avroObject -> ((Integer)avroObject).byteValue();
            }
            case SMALLINT: {
                return avroObject -> ((Integer)avroObject).shortValue();
            }
            case BOOLEAN: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return avroObject -> avroObject;
            }
            case DATE: {
                return AvroToRowDataConverters::convertToDate;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return AvroToRowDataConverters::convertToTime;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int precision = ((TimestampType)type).getPrecision();
                if (precision <= 3) {
                    return AvroToRowDataConverters::convertToTimestampFromMillis;
                }
                if (precision <= 6) {
                    return AvroToRowDataConverters::convertToTimestampFromMicros;
                }
                throw new UnsupportedOperationException("Unsupported precision: " + precision);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int precision = ((LocalZonedTimestampType)type).getPrecision();
                if (precision <= 3) {
                    return AvroToRowDataConverters::convertToTimestampFromMillis;
                }
                if (precision <= 6) {
                    return AvroToRowDataConverters::convertToTimestampFromMicros;
                }
                throw new UnsupportedOperationException("Unsupported precision: " + precision);
            }
            case CHAR: 
            case VARCHAR: {
                return avroObject -> BinaryString.fromString((String)avroObject.toString());
            }
            case BINARY: 
            case VARBINARY: {
                return AvroToRowDataConverters::convertToBytes;
            }
            case DECIMAL: {
                return AvroToRowDataConverters.createDecimalConverter((DecimalType)type);
            }
            case ARRAY: {
                return AvroToRowDataConverters.createArrayConverter((ArrayType)type);
            }
            case ROW: {
                return AvroToRowDataConverters.createRowConverter((RowType)type);
            }
            case MAP: 
            case MULTISET: {
                return AvroToRowDataConverters.createMapConverter(type);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static AvroToRowDataConverter createDecimalConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return avroObject -> {
            byte[] bytes;
            if (avroObject instanceof GenericFixed) {
                bytes = ((GenericFixed)avroObject).bytes();
            } else if (avroObject instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)avroObject;
                bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
            } else {
                bytes = (byte[])avroObject;
            }
            return Decimal.fromUnscaledBytes((byte[])bytes, (int)precision, (int)scale);
        };
    }

    private static AvroToRowDataConverter createArrayConverter(ArrayType arrayType) {
        AvroToRowDataConverter elementConverter = AvroToRowDataConverters.createNullableConverter(arrayType.getElementType());
        Class elementClass = InternalRow.getDataClass((DataType)arrayType.getElementType());
        return avroObject -> {
            List list = (List)avroObject;
            int length = list.size();
            Object[] array = (Object[])Array.newInstance(elementClass, length);
            for (int i = 0; i < length; ++i) {
                array[i] = elementConverter.convert(list.get(i));
            }
            return new GenericArray(array);
        };
    }

    private static AvroToRowDataConverter createMapConverter(DataType type) {
        AvroToRowDataConverter keyConverter = AvroToRowDataConverters.createConverter((DataType)DataTypes.STRING());
        AvroToRowDataConverter valueConverter = AvroToRowDataConverters.createNullableConverter(AvroSchemaConverter.extractValueTypeToAvroMap(type));
        return avroObject -> {
            Map map = (Map)avroObject;
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                Object key = keyConverter.convert(entry.getKey());
                Object value = valueConverter.convert(entry.getValue());
                result.put(key, value);
            }
            return new GenericMap(result);
        };
    }

    private static Timestamp convertToTimestampFromMillis(Object object) {
        return AvroToRowDataConverters.convertToTimestamp(object, 3);
    }

    private static Timestamp convertToTimestampFromMicros(Object object) {
        return AvroToRowDataConverters.convertToTimestamp(object, 6);
    }

    @VisibleForTesting
    static Timestamp convertToTimestamp(Object object, int precision) {
        if (object instanceof Long) {
            if (precision <= 3) {
                return Timestamp.fromEpochMillis((long)((Long)object));
            }
            if (precision <= 6) {
                return Timestamp.fromMicros((long)((Long)object));
            }
            throw new UnsupportedOperationException("Unsupported precision: " + precision);
        }
        if (object instanceof Instant) {
            return Timestamp.fromInstant((Instant)((Instant)object));
        }
        JodaConverter jodaConverter = JodaConverter.getConverter();
        if (jodaConverter != null) {
            return Timestamp.fromEpochMillis((long)jodaConverter.convertTimestamp(object));
        }
        throw new IllegalArgumentException("Unexpected object type for TIMESTAMP logical type. Received: " + object);
    }

    private static int convertToDate(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof LocalDate) {
            return (int)((LocalDate)object).toEpochDay();
        }
        JodaConverter jodaConverter = JodaConverter.getConverter();
        if (jodaConverter != null) {
            return (int)jodaConverter.convertDate(object);
        }
        throw new IllegalArgumentException("Unexpected object type for DATE logical type. Received: " + object);
    }

    private static int convertToTime(Object object) {
        int millis;
        if (object instanceof Integer) {
            millis = (Integer)object;
        } else if (object instanceof LocalTime) {
            millis = ((LocalTime)object).get(ChronoField.MILLI_OF_DAY);
        } else {
            JodaConverter jodaConverter = JodaConverter.getConverter();
            if (jodaConverter != null) {
                millis = jodaConverter.convertTime(object);
            } else {
                throw new IllegalArgumentException("Unexpected object type for TIME logical type. Received: " + object);
            }
        }
        return millis;
    }

    private static byte[] convertToBytes(Object object) {
        if (object instanceof GenericFixed) {
            return ((GenericFixed)object).bytes();
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        return (byte[])object;
    }

    @FunctionalInterface
    public static interface AvroToRowDataConverter
    extends Serializable {
        public Object convert(Object var1);
    }
}

