/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.meta.AuditInfo;

public class CatalogEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The catalog's unique identifier");
    public static final Field NAME = Field.required("name", String.class, "The catalog's name");
    public static final Field TYPE = Field.required("type", Catalog.Type.class, "The type of the catalog");
    public static final Field PROVIDER = Field.required("provider", String.class, "The provider of the catalog");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment or description of the catalog");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties associated with the catalog");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the catalog");
    private Long id;
    private String name;
    private Catalog.Type type;
    private String provider;
    @Nullable
    private String comment;
    @Nullable
    private Map<String, String> properties;
    private AuditInfo auditInfo;
    private Namespace namespace;

    @Override
    public Map<Field, Object> fields() {
        HashMap<Field, Object> fields = new HashMap<Field, Object>();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(COMMENT, this.comment);
        fields.put(TYPE, this.type);
        fields.put(PROVIDER, this.provider);
        fields.put(PROPERTIES, this.properties);
        fields.put(AUDIT_INFO, this.auditInfo);
        return Collections.unmodifiableMap(fields);
    }

    public Audit auditInfo() {
        return this.auditInfo;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.CATALOG;
    }

    public CatalogInfo toCatalogInfo() {
        return new CatalogInfo(this.id, this.name, this.type, this.provider, this.comment, this.properties, this.auditInfo, this.namespace);
    }

    public CatalogInfo toCatalogInfoWithoutHiddenProps(Set<String> hiddenKeys) {
        HashMap<String, String> filteredProperties = this.properties == null ? new HashMap<String, String>() : new HashMap<String, String>(this.properties);
        filteredProperties.keySet().removeAll(hiddenKeys);
        return new CatalogInfo(this.id, this.name, this.type, this.provider, this.comment, filteredProperties, this.auditInfo, this.namespace);
    }

    public CatalogInfo toCatalogInfoWithResolvedProps(Map<String, String> resolvedProperties) {
        return new CatalogInfo(this.id, this.name, this.type, this.provider, this.comment, resolvedProperties, this.auditInfo, this.namespace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CatalogEntity)) {
            return false;
        }
        CatalogEntity that = (CatalogEntity)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.namespace, (Object)that.namespace) && this.type == that.type && Objects.equal((Object)this.provider, (Object)that.provider) && Objects.equal((Object)this.comment, (Object)that.comment) && Objects.equal(this.properties, that.properties) && Objects.equal((Object)this.auditInfo, (Object)that.auditInfo);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.type, this.provider, this.comment, this.properties, this.auditInfo});
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "CatalogEntity(id=" + this.id + ", name=" + this.name + ", type=" + this.getType() + ", provider=" + this.getProvider() + ", comment=" + this.getComment() + ", properties=" + this.getProperties() + ", auditInfo=" + this.auditInfo + ", namespace=" + this.namespace + ")";
    }

    public Catalog.Type getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static class Builder {
        private final CatalogEntity catalog = new CatalogEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.catalog.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.catalog.name = name;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.catalog.namespace = namespace;
            return this;
        }

        public Builder withType(Catalog.Type type) {
            this.catalog.type = type;
            return this;
        }

        public Builder withProvider(String provider) {
            this.catalog.provider = provider;
            return this;
        }

        public Builder withComment(String comment) {
            this.catalog.comment = comment;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.catalog.properties = properties;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.catalog.auditInfo = auditInfo;
            return this;
        }

        public CatalogEntity build() {
            this.catalog.validate();
            return this.catalog;
        }
    }
}

