/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.audit.CallerContext;
import org.apache.gravitino.catalog.FilesetDispatcher;
import org.apache.gravitino.dto.requests.FilesetCreateRequest;
import org.apache.gravitino.dto.requests.FilesetUpdateRequest;
import org.apache.gravitino.dto.requests.FilesetUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.FileLocationResponse;
import org.apache.gravitino.dto.responses.FilesetResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="metalakes/{metalake}/catalogs/{catalog}/schemas/{schema}/filesets")
public class FilesetOperations {
    private static final Logger LOG = LoggerFactory.getLogger(FilesetOperations.class);
    private final FilesetDispatcher dispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public FilesetOperations(FilesetDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-fileset.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-fileset", absolute=true)
    public Response listFilesets(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema) {
        try {
            LOG.info("Received list filesets request for schema: {}.{}.{}", new Object[]{metalake, catalog, schema});
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                Namespace filesetNS = NamespaceUtil.ofFileset((String)metalake, (String)catalog, (String)schema);
                NameIdentifier[] idents = this.dispatcher.listFilesets(filesetNS);
                Response response = Utils.ok((Object)new EntityListResponse(idents));
                LOG.info("List {} filesets under schema: {}.{}.{}", new Object[]{idents.length, metalake, catalog, schema});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleFilesetException(OperationType.LIST, "", schema, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-fileset.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-fileset", absolute=true)
    public Response createFileset(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, FilesetCreateRequest request) {
        LOG.info("Received create fileset request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, request.getName()});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofFileset((String)metalake, (String)catalog, (String)schema, (String)request.getName());
                HashMap tmpLocations = new HashMap(Optional.ofNullable(request.getStorageLocations()).orElse(Collections.emptyMap()));
                Optional.ofNullable(request.getStorageLocation()).ifPresent(loc -> tmpLocations.put("unknown", loc));
                ImmutableMap storageLocations = ImmutableMap.copyOf(tmpLocations);
                Fileset fileset = this.dispatcher.createMultipleLocationFileset(ident, request.getComment(), Optional.ofNullable(request.getType()).orElse(Fileset.Type.MANAGED), (Map)storageLocations, request.getProperties());
                Response response = Utils.ok((Object)new FilesetResponse(DTOConverters.toDTO((Fileset)fileset)));
                LOG.info("Fileset created: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, request.getName()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleFilesetException(OperationType.CREATE, request.getName(), schema, e);
        }
    }

    @GET
    @Path(value="{fileset}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="load-fileset.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-fileset", absolute=true)
    public Response loadFileset(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="fileset") String fileset) {
        LOG.info("Received load fileset request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, fileset});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                NameIdentifier ident = NameIdentifierUtil.ofFileset((String)metalake, (String)catalog, (String)schema, (String)fileset);
                Fileset t = this.dispatcher.loadFileset(ident);
                Response response = Utils.ok((Object)new FilesetResponse(DTOConverters.toDTO((Fileset)t)));
                LOG.info("Fileset loaded: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, fileset});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleFilesetException(OperationType.LOAD, fileset, schema, e);
        }
    }

    @PUT
    @Path(value="{fileset}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-fileset.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-fileset", absolute=true)
    public Response alterFileset(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="fileset") String fileset, FilesetUpdatesRequest request) {
        LOG.info("Received alter fileset request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, fileset});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofFileset((String)metalake, (String)catalog, (String)schema, (String)fileset);
                FilesetChange[] changes = (FilesetChange[])request.getUpdates().stream().map(FilesetUpdateRequest::filesetChange).toArray(FilesetChange[]::new);
                Fileset t = this.dispatcher.alterFileset(ident, changes);
                Response response = Utils.ok((Object)new FilesetResponse(DTOConverters.toDTO((Fileset)t)));
                LOG.info("Fileset altered: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, t.name()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleFilesetException(OperationType.ALTER, fileset, schema, e);
        }
    }

    @DELETE
    @Path(value="{fileset}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="drop-fileset.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-fileset", absolute=true)
    public Response dropFileset(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="fileset") String fileset) {
        LOG.info("Received drop fileset request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, fileset});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                NameIdentifier ident = NameIdentifierUtil.ofFileset((String)metalake, (String)catalog, (String)schema, (String)fileset);
                boolean dropped = this.dispatcher.dropFileset(ident);
                if (!dropped) {
                    LOG.warn("Failed to drop fileset {} under schema {}", (Object)fileset, (Object)schema);
                }
                Response response = Utils.ok((Object)new DropResponse(dropped));
                LOG.info("Fileset dropped: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, fileset});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleFilesetException(OperationType.DROP, fileset, schema, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{fileset}/location")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-file-location.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-file-location", absolute=true)
    public Response getFileLocation(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="fileset") String fileset, @QueryParam(value="sub_path") @NotNull String subPath, @QueryParam(value="location_name") String locationName) {
        LOG.info("Received get file location request: {}.{}.{}.{}, sub path:{}, location name:{}", new Object[]{metalake, catalog, schema, fileset, RESTUtils.decodeString((String)subPath), Optional.ofNullable(locationName).map(RESTUtils::decodeString).orElse(null)});
        try {
            Response response = Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                NameIdentifier ident = NameIdentifierUtil.ofFileset((String)metalake, (String)catalog, (String)schema, (String)fileset);
                Map filteredAuditHeaders = Utils.filterFilesetAuditHeaders((HttpServletRequest)this.httpRequest);
                if (!filteredAuditHeaders.isEmpty()) {
                    CallerContext context = CallerContext.builder().withContext(filteredAuditHeaders).build();
                    CallerContext.CallerContextHolder.set((CallerContext)context);
                }
                String actualFileLocation = this.dispatcher.getFileLocation(ident, RESTUtils.decodeString((String)subPath), (String)Optional.ofNullable(locationName).map(RESTUtils::decodeString).orElse(null));
                return Utils.ok((Object)new FileLocationResponse(actualFileLocation));
            });
            return response;
        }
        catch (Exception e) {
            Response response = ExceptionHandlers.handleFilesetException(OperationType.GET, fileset, schema, e);
            return response;
        }
        finally {
            CallerContext.CallerContextHolder.remove();
        }
    }
}

