/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.dto.authorization.PrivilegeDTO;
import org.apache.gravitino.dto.requests.PrivilegeGrantRequest;
import org.apache.gravitino.dto.requests.PrivilegeRevokeRequest;
import org.apache.gravitino.dto.requests.RoleGrantRequest;
import org.apache.gravitino.dto.requests.RoleRevokeRequest;
import org.apache.gravitino.dto.responses.GroupResponse;
import org.apache.gravitino.dto.responses.RoleResponse;
import org.apache.gravitino.dto.responses.UserResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.server.authorization.NameBindings;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.MetadataObjectUtil;

@NameBindings.AccessControlInterfaces
@Path(value="/metalakes/{metalake}/permissions")
public class PermissionOperations {
    private final AccessControlDispatcher accessControlManager = GravitinoEnv.getInstance().accessControlDispatcher();
    @Context
    private HttpServletRequest httpRequest;

    @PUT
    @Path(value="users/{user}/grant/")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="grant-roles-to-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="grant-roles-to-user", absolute=true)
    public Response grantRolesToUser(@PathParam(value="metalake") String metalake, @PathParam(value="user") String user, RoleGrantRequest request) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                return Utils.ok((Object)new UserResponse(DTOConverters.toDTO((User)this.accessControlManager.grantRolesToUser(metalake, request.getRoleNames(), user))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserPermissionOperationException(OperationType.GRANT, StringUtils.join((Iterable)request.getRoleNames(), (String)","), user, e);
        }
    }

    @PUT
    @Path(value="groups/{group}/grant/")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="grant-roles-to-group.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="grant-roles-to-group", absolute=true)
    public Response grantRolesToGroup(@PathParam(value="metalake") String metalake, @PathParam(value="group") String group, RoleGrantRequest request) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                return Utils.ok((Object)new GroupResponse(DTOConverters.toDTO((Group)this.accessControlManager.grantRolesToGroup(metalake, request.getRoleNames(), group))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleGroupPermissionOperationException(OperationType.GRANT, StringUtils.join((Iterable)request.getRoleNames(), (String)","), group, e);
        }
    }

    @PUT
    @Path(value="users/{user}/revoke/")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="revoke-roles-from-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="revoke-roles-from-user", absolute=true)
    public Response revokeRolesFromUser(@PathParam(value="metalake") String metalake, @PathParam(value="user") String user, RoleRevokeRequest request) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                return Utils.ok((Object)new UserResponse(DTOConverters.toDTO((User)this.accessControlManager.revokeRolesFromUser(metalake, request.getRoleNames(), user))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserPermissionOperationException(OperationType.REVOKE, StringUtils.join((Iterable)request.getRoleNames(), (String)","), user, e);
        }
    }

    @PUT
    @Path(value="groups/{group}/revoke")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="revoke-roles-from-group.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="revokes-role-from-group", absolute=true)
    public Response revokeRolesFromGroup(@PathParam(value="metalake") String metalake, @PathParam(value="group") String group, RoleRevokeRequest request) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                return Utils.ok((Object)new GroupResponse(DTOConverters.toDTO((Group)this.accessControlManager.revokeRolesFromGroup(metalake, request.getRoleNames(), group))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleGroupPermissionOperationException(OperationType.REVOKE, StringUtils.join((Object[])new List[]{request.getRoleNames()}), group, e);
        }
    }

    @PUT
    @Path(value="roles/{role}/{type}/{fullName}/grant/")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="grant-privilege-to-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="grant-privilege-to-role", absolute=true)
    public Response grantPrivilegeToRole(@PathParam(value="metalake") String metalake, @PathParam(value="role") String role, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName, PrivilegeGrantRequest privilegeGrantRequest) {
        try {
            MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                privilegeGrantRequest.validate();
                for (PrivilegeDTO privilegeDTO : privilegeGrantRequest.getPrivileges()) {
                    AuthorizationUtils.checkPrivilege((PrivilegeDTO)privilegeDTO, (MetadataObject)object, (String)metalake);
                }
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                return Utils.ok((Object)new RoleResponse(DTOConverters.toDTO((Role)this.accessControlManager.grantPrivilegeToRole(metalake, role, object, privilegeGrantRequest.getPrivileges().stream().map(DTOConverters::fromPrivilegeDTO).collect(Collectors.toSet())))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRolePermissionOperationException(OperationType.GRANT, fullName, role, e);
        }
    }

    @PUT
    @Path(value="roles/{role}/{type}/{fullName}/revoke/")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="revoke-privilege-from-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="revoke-privilege-from-role", absolute=true)
    public Response revokePrivilegeFromRole(@PathParam(value="metalake") String metalake, @PathParam(value="role") String role, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName, PrivilegeRevokeRequest privilegeRevokeRequest) {
        try {
            MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                privilegeRevokeRequest.validate();
                for (PrivilegeDTO privilegeDTO : privilegeRevokeRequest.getPrivileges()) {
                    AuthorizationUtils.checkPrivilege((PrivilegeDTO)privilegeDTO, (MetadataObject)object, (String)metalake);
                }
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                return Utils.ok((Object)new RoleResponse(DTOConverters.toDTO((Role)this.accessControlManager.revokePrivilegesFromRole(metalake, role, object, privilegeRevokeRequest.getPrivileges().stream().map(DTOConverters::fromPrivilegeDTO).collect(Collectors.toSet())))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRolePermissionOperationException(OperationType.REVOKE, fullName, role, e);
        }
    }
}

