/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.hash;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.io.PageFileInput;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.io.cache.FileBasedRandomInputView;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.lookup.hash.HashContext;
import org.apache.paimon.utils.FileBasedBloomFilter;
import org.apache.paimon.utils.MurmurHashUtils;
import org.apache.paimon.utils.VarLengthIntUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashLookupStoreReader
implements LookupStoreReader,
Iterable<Map.Entry<byte[], byte[]>> {
    private static final Logger LOG = LoggerFactory.getLogger((String)HashLookupStoreReader.class.getName());
    private final int[] keyCounts;
    private final int[] slotSizes;
    private final int[] slots;
    private final int[] indexOffsets;
    private final long[] dataOffsets;
    private FileBasedRandomInputView inputView;
    private final byte[] slotBuffer;
    @Nullable
    private FileBasedBloomFilter bloomFilter;

    HashLookupStoreReader(File file, HashContext context, CacheManager cacheManager, int cachePageSize, @Nullable BlockCompressionFactory compressionFactory) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found");
        }
        this.keyCounts = context.keyCounts;
        this.slots = context.slots;
        this.slotSizes = context.slotSizes;
        int maxSlotSize = 0;
        for (int slotSize : this.slotSizes) {
            maxSlotSize = Math.max(maxSlotSize, slotSize);
        }
        this.slotBuffer = new byte[maxSlotSize];
        this.indexOffsets = context.indexOffsets;
        this.dataOffsets = context.dataOffsets;
        LOG.info("Opening file {}", (Object)file.getName());
        PageFileInput fileInput = PageFileInput.create(file, cachePageSize, compressionFactory, context.uncompressBytes, context.compressPages);
        this.inputView = new FileBasedRandomInputView(fileInput, cacheManager);
        if (context.bloomFilterEnabled) {
            this.bloomFilter = new FileBasedBloomFilter(fileInput, cacheManager, context.bloomFilterExpectedEntries, 0L, context.bloomFilterBytes);
        }
    }

    @Override
    public byte[] lookup(byte[] key) throws IOException {
        int keyLength = key.length;
        if (keyLength >= this.slots.length || this.keyCounts[keyLength] == 0) {
            return null;
        }
        int hashcode = MurmurHashUtils.hashBytes(key);
        if (this.bloomFilter != null && !this.bloomFilter.testHash(hashcode)) {
            return null;
        }
        long hashPositive = hashcode & Integer.MAX_VALUE;
        int numSlots = this.slots[keyLength];
        int slotSize = this.slotSizes[keyLength];
        int indexOffset = this.indexOffsets[keyLength];
        long dataOffset = this.dataOffsets[keyLength];
        for (int probe = 0; probe < numSlots; ++probe) {
            long slot = (hashPositive + (long)probe) % (long)numSlots;
            this.inputView.setReadPosition((long)indexOffset + slot * (long)slotSize);
            this.inputView.readFully(this.slotBuffer, 0, slotSize);
            long offset = VarLengthIntUtils.decodeLong(this.slotBuffer, keyLength);
            if (offset == 0L) {
                return null;
            }
            if (!this.isKey(this.slotBuffer, key)) continue;
            return this.getValue(dataOffset + offset);
        }
        return null;
    }

    private boolean isKey(byte[] slotBuffer, byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            if (slotBuffer[i] == key[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] getValue(long offset) throws IOException {
        this.inputView.setReadPosition(offset);
        int size = VarLengthIntUtils.decodeInt(this.inputView);
        byte[] res = new byte[size];
        this.inputView.readFully(res);
        return res;
    }

    @Override
    public void close() throws IOException {
        this.inputView.close();
        this.inputView = null;
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return new StorageIterator(true);
    }

    public Iterator<Map.Entry<byte[], byte[]>> keys() {
        return new StorageIterator(false);
    }

    private class StorageIterator
    implements Iterator<Map.Entry<byte[], byte[]>> {
        private final FastEntry entry = new FastEntry();
        private final boolean withValue;
        private int currentKeyLength = 0;
        private byte[] currentSlotBuffer;
        private long keyIndex;
        private long keyLimit;
        private long currentDataOffset;
        private int currentIndexOffset;

        public StorageIterator(boolean value) {
            this.withValue = value;
            this.nextKeyLength();
        }

        private void nextKeyLength() {
            for (int i = this.currentKeyLength + 1; i < HashLookupStoreReader.this.keyCounts.length; ++i) {
                long c = HashLookupStoreReader.this.keyCounts[i];
                if (c <= 0L) continue;
                this.currentKeyLength = i;
                this.keyLimit += c;
                this.currentSlotBuffer = new byte[HashLookupStoreReader.this.slotSizes[i]];
                this.currentIndexOffset = HashLookupStoreReader.this.indexOffsets[i];
                this.currentDataOffset = HashLookupStoreReader.this.dataOffsets[i];
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.keyIndex < this.keyLimit;
        }

        @Override
        public FastEntry next() {
            try {
                HashLookupStoreReader.this.inputView.setReadPosition(this.currentIndexOffset);
                long offset = 0L;
                while (offset == 0L) {
                    HashLookupStoreReader.this.inputView.readFully(this.currentSlotBuffer);
                    offset = VarLengthIntUtils.decodeLong(this.currentSlotBuffer, this.currentKeyLength);
                    this.currentIndexOffset += this.currentSlotBuffer.length;
                }
                byte[] key = Arrays.copyOf(this.currentSlotBuffer, this.currentKeyLength);
                byte[] value = null;
                if (this.withValue) {
                    long valueOffset = this.currentDataOffset + offset;
                    value = HashLookupStoreReader.this.getValue(valueOffset);
                }
                this.entry.set(key, value);
                if (++this.keyIndex == this.keyLimit) {
                    this.nextKeyLength();
                }
                return this.entry;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private class FastEntry
        implements Map.Entry<byte[], byte[]> {
            private byte[] key;
            private byte[] val;

            private FastEntry() {
            }

            protected void set(byte[] k, byte[] v) {
                this.key = k;
                this.val = v;
            }

            @Override
            public byte[] getKey() {
                return this.key;
            }

            @Override
            public byte[] getValue() {
                return this.val;
            }

            @Override
            public byte[] setValue(byte[] value) {
                throw new UnsupportedOperationException("Not supported.");
            }
        }
    }
}

