/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class TypeConverter {
    public static Type convert(String typeName) {
        switch (typeName.toLowerCase()) {
            case "null": {
                return Types.NullType.get();
            }
            case "boolean": {
                return Types.BooleanType.get();
            }
            case "byte": {
                return Types.ByteType.get();
            }
            case "ubyte": {
                return Types.ByteType.unsigned();
            }
            case "short": {
                return Types.ShortType.get();
            }
            case "ushort": {
                return Types.ShortType.unsigned();
            }
            case "integer": {
                return Types.IntegerType.get();
            }
            case "uinteger": {
                return Types.IntegerType.unsigned();
            }
            case "long": {
                return Types.LongType.get();
            }
            case "ulong": {
                return Types.LongType.unsigned();
            }
            case "float": {
                return Types.FloatType.get();
            }
            case "double": {
                return Types.DoubleType.get();
            }
            case "date": {
                return Types.DateType.get();
            }
            case "time": {
                return Types.TimeType.get();
            }
            case "timestamp": {
                return Types.TimestampType.withoutTimeZone();
            }
            case "tztimestamp": {
                return Types.TimestampType.withTimeZone();
            }
            case "intervalyear": {
                return Types.IntervalYearType.get();
            }
            case "intervalday": {
                return Types.IntervalDayType.get();
            }
            case "uuid": {
                return Types.UUIDType.get();
            }
            case "string": {
                return Types.StringType.get();
            }
            case "binary": {
                return Types.BinaryType.get();
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported type: " + typeName);
    }

    public static Type convert(String typeName, int length) {
        if (typeName.toLowerCase().startsWith("fixed")) {
            return Types.FixedType.of(length);
        }
        if (typeName.toLowerCase().startsWith("varchar")) {
            return Types.VarCharType.of(length);
        }
        if (typeName.toLowerCase().startsWith("char")) {
            return Types.FixedCharType.of(length);
        }
        throw new IllegalArgumentException("Unknown or unsupported variable length type: " + typeName);
    }

    public static Type convert(String typeName, int precision, int scale) {
        if (typeName.toLowerCase().startsWith("decimal")) {
            return Types.DecimalType.of(precision, scale);
        }
        throw new IllegalArgumentException("Unknown or unsupported precision and scale type: " + typeName);
    }
}

