/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Auditable;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.AuditCommand;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchTableException;

public class ColumnAudit
extends AuditCommand {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String table;
    protected final String column;

    public ColumnAudit(CommandContext context, String metalake, String catalog, String schema, String table, String column) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.column = column;
    }

    @Override
    public void handle() {
        Auditable result = null;
        try (GravitinoClient client = this.buildClient(this.metalake);){
            result = client.loadCatalog(this.catalog);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (NoSuchColumnException err) {
            this.exitWithError("Unknown column name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (result != null) {
            this.displayAuditInfo(result.auditInfo());
        }
    }
}

