/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.ListProperties;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.Fileset;

public class ListFilesetProperties
extends ListProperties {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String fileset;

    public ListFilesetProperties(CommandContext context, String metalake, String catalog, String schema, String fileset) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.fileset = fileset;
    }

    @Override
    public void handle() {
        Fileset gFileset = null;
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.fileset);
            GravitinoClient client = this.buildClient(this.metalake);
            gFileset = client.loadCatalog(this.catalog).asFilesetCatalog().loadFileset(name);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        Map<String, String> properties = gFileset.properties();
        this.printProperties(properties);
    }
}

