/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Audit;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.TableCommand;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;

public class ListTables
extends TableCommand {
    protected final String schema;

    public ListTables(CommandContext context, String metalake, String catalog, String schema) {
        super(context, metalake, catalog);
        this.schema = schema;
    }

    @Override
    public void handle() {
        NameIdentifier[] tables = null;
        Namespace name = Namespace.of(this.schema);
        try {
            tables = this.tableCatalog().listTables(name);
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (tables.length == 0) {
            this.printInformation("No tables exist.");
            return;
        }
        Table[] gTables = new Table[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            final String tableName = tables[i].name();
            gTables[i] = new Table(){

                @Override
                public String name() {
                    return tableName;
                }

                @Override
                public Column[] columns() {
                    return new Column[0];
                }

                @Override
                public Audit auditInfo() {
                    return null;
                }
            };
        }
        this.printResults(gTables);
    }
}

