/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.outputs;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.Schema;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.outputs.BaseOutputFormat;
import org.apache.gravitino.cli.outputs.LineUtil;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;

public abstract class PlainFormat<T>
extends BaseOutputFormat<T> {
    public static void output(Object entity, CommandContext context) {
        if (entity instanceof Metalake) {
            new MetalakePlainFormat(context).output((Metalake)entity);
        } else if (entity instanceof Metalake[]) {
            new MetalakeListPlainFormat(context).output((Metalake[])entity);
        } else if (entity instanceof Catalog) {
            new CatalogPlainFormat(context).output((Catalog)entity);
        } else if (entity instanceof Catalog[]) {
            new CatalogListPlainFormat(context).output((Catalog[])entity);
        } else if (entity instanceof Schema) {
            new SchemaPlainFormat(context).output((Schema)entity);
        } else if (entity instanceof Schema[]) {
            new SchemaListPlainFormat(context).output((Schema[])entity);
        } else if (entity instanceof Table) {
            new TablePlainFormat(context).output((Table)entity);
        } else if (entity instanceof Table[]) {
            new TableListPlainFormat(context).output((Table[])entity);
        } else if (entity instanceof Audit) {
            new AuditPlainFormat(context).output((Audit)entity);
        } else if (entity instanceof Column[]) {
            new ColumnListPlainFormat(context).output((Column[])entity);
        } else {
            throw new IllegalArgumentException("Unsupported object type");
        }
    }

    public PlainFormat(CommandContext context) {
        super(context);
    }

    static final class ColumnListPlainFormat
    extends PlainFormat<Column[]> {
        public ColumnListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Column[] columns) {
            String header = COMMA_JOINER.join("name", "datatype", "default_value", "comment", "nullable", "auto_increment");
            StringBuilder data = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                String name = columns[i].name();
                String dataType = columns[i].dataType().simpleString();
                String defaultValue = LineUtil.getDefaultValue(columns[i]);
                String comment = LineUtil.getComment(columns[i]);
                String nullable = columns[i].nullable() ? "true" : "false";
                String autoIncrement = LineUtil.getAutoIncrement(columns[i]);
                data.append(COMMA_JOINER.join(name, dataType, defaultValue, comment, nullable, autoIncrement));
                data.append(System.lineSeparator());
            }
            return NEWLINE_JOINER.join(header, data.toString(), new Object[0]);
        }
    }

    static final class AuditPlainFormat
    extends PlainFormat<Audit> {
        public AuditPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Audit audit) {
            return COMMA_JOINER.join(audit.creator(), audit.createTime() == null ? "N/A" : audit.createTime(), audit.lastModifier() == null ? "N/A" : audit.lastModifier(), audit.lastModifiedTime() == null ? "N/A" : audit.lastModifiedTime());
        }
    }

    static final class TableListPlainFormat
    extends PlainFormat<Table[]> {
        public TableListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Table[] tables) {
            List tableNames = Arrays.stream(tables).map(Table::name).collect(Collectors.toList());
            return NEWLINE_JOINER.join(tableNames);
        }
    }

    static final class TablePlainFormat
    extends PlainFormat<Table> {
        public TablePlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Table table) {
            String comment = table.comment() == null ? "N/A" : table.comment();
            return COMMA_JOINER.join(new String[]{table.name(), comment});
        }
    }

    static final class SchemaListPlainFormat
    extends PlainFormat<Schema[]> {
        public SchemaListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Schema[] schemas) {
            List schemaNames = Arrays.stream(schemas).map(Schema::name).collect(Collectors.toList());
            return NEWLINE_JOINER.join(schemaNames);
        }
    }

    static final class SchemaPlainFormat
    extends PlainFormat<Schema> {
        public SchemaPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Schema schema) {
            return COMMA_JOINER.join(schema.name(), schema.comment(), new Object[0]);
        }
    }

    static final class CatalogListPlainFormat
    extends PlainFormat<Catalog[]> {
        public CatalogListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Catalog[] catalogs) {
            List catalogNames = Arrays.stream(catalogs).map(Catalog::name).collect(Collectors.toList());
            return NEWLINE_JOINER.join(catalogNames);
        }
    }

    static final class CatalogPlainFormat
    extends PlainFormat<Catalog> {
        public CatalogPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Catalog catalog) {
            return COMMA_JOINER.join(catalog.name(), (Object)catalog.type(), catalog.provider(), catalog.comment());
        }
    }

    static final class MetalakeListPlainFormat
    extends PlainFormat<Metalake[]> {
        public MetalakeListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Metalake[] metalakes) {
            List metalakeNames = Arrays.stream(metalakes).map(Metalake::name).collect(Collectors.toList());
            return NEWLINE_JOINER.join(metalakeNames);
        }
    }

    static final class MetalakePlainFormat
    extends PlainFormat<Metalake> {
        public MetalakePlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Metalake metalake) {
            return COMMA_JOINER.join(metalake.name(), metalake.comment(), new Object[0]);
        }
    }
}

