/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.config;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class JdbcConfig
extends Config {
    public static final ConfigEntry<String> JDBC_URL = new ConfigBuilder("jdbc-url").doc("The url of the Jdbc connection").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> JDBC_DATABASE = new ConfigBuilder("jdbc-database").doc("The database of the jdbc connection").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> JDBC_DRIVER = new ConfigBuilder("jdbc-driver").doc("The driver of the jdbc connection").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> USERNAME = new ConfigBuilder("jdbc-user").doc("The username of the Jdbc connection").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> PASSWORD = new ConfigBuilder("jdbc-password").doc("The password of the Jdbc connection").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<Integer> POOL_MIN_SIZE = new ConfigBuilder("jdbc.pool.min-size").doc("The minimum number of connections in the pool").version("0.3.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)2);
    public static final ConfigEntry<Integer> POOL_MAX_SIZE = new ConfigBuilder("jdbc.pool.max-size").doc("The maximum number of connections in the pool").version("0.3.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)10);
    public static final ConfigEntry<Boolean> TEST_ON_BORROW = new ConfigBuilder("jdbc.pool.test-on-borrow").doc("Whether to test the connection on borrow").version("0.5.0").booleanConf().createWithDefault((Object)true);

    public String getJdbcUrl() {
        return (String)this.get(JDBC_URL);
    }

    public String getJdbcDriver() {
        return (String)this.get(JDBC_DRIVER);
    }

    public String getUsername() {
        return (String)this.get(USERNAME);
    }

    public String getPassword() {
        return (String)this.get(PASSWORD);
    }

    public int getPoolMinSize() {
        return (Integer)this.get(POOL_MIN_SIZE);
    }

    public int getPoolMaxSize() {
        return (Integer)this.get(POOL_MAX_SIZE);
    }

    public String getJdbcDatabase() {
        return (String)this.get(JDBC_DATABASE);
    }

    public boolean getTestOnBorrow() {
        return (Boolean)this.get(TEST_ON_BORROW);
    }

    public JdbcConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }
}

