/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.operation;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.catalog.jdbc.JdbcColumn;
import org.apache.gravitino.catalog.jdbc.JdbcTable;
import org.apache.gravitino.catalog.jdbc.bean.JdbcIndexBean;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.catalog.jdbc.operation.TableOperation;
import org.apache.gravitino.catalog.jdbc.utils.JdbcConnectorUtils;
import org.apache.gravitino.connector.BaseColumn;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcTableOperations
implements TableOperation {
    public static final String COMMENT = "COMMENT";
    public static final String SPACE = " ";
    public static final String MODIFY_COLUMN = "MODIFY COLUMN ";
    public static final String AFTER = "AFTER ";
    protected static final Logger LOG = LoggerFactory.getLogger(JdbcTableOperations.class);
    protected DataSource dataSource;
    protected JdbcExceptionConverter exceptionMapper;
    protected JdbcTypeConverter typeConverter;
    protected JdbcColumnDefaultValueConverter columnDefaultValueConverter;

    @Override
    public void initialize(DataSource dataSource, JdbcExceptionConverter exceptionMapper, JdbcTypeConverter jdbcTypeConverter, JdbcColumnDefaultValueConverter jdbcColumnDefaultValueConverter, Map<String, String> conf) {
        this.dataSource = dataSource;
        this.exceptionMapper = exceptionMapper;
        this.typeConverter = jdbcTypeConverter;
        this.columnDefaultValueConverter = jdbcColumnDefaultValueConverter;
    }

    @Override
    public void create(String databaseName, String tableName, JdbcColumn[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, Index[] indexes) throws TableAlreadyExistsException {
        LOG.info("Attempting to create table {} in database {}", (Object)tableName, (Object)databaseName);
        try (Connection connection = this.getConnection(databaseName);){
            JdbcConnectorUtils.executeUpdate(connection, this.generateCreateTableSql(tableName, columns, comment, properties, partitioning, distribution, indexes));
            LOG.info("Created table {} in database {}", (Object)tableName, (Object)databaseName);
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    @Override
    public boolean drop(String databaseName, String tableName) {
        LOG.info("Attempting to delete table {} from database {}", (Object)tableName, (Object)databaseName);
        try {
            this.dropTable(databaseName, tableName);
            LOG.info("Deleted table {} from database {}", (Object)tableName, (Object)databaseName);
        }
        catch (NoSuchTableException e) {
            return false;
        }
        catch (NoSuchSchemaException e) {
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> listTables(String databaseName) throws NoSuchSchemaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected JdbcTable.Builder getTableBuilder(ResultSet tablesResult, String databaseName, String tableName) throws SQLException {
        boolean found = false;
        JdbcTable.Builder builder = null;
        while (tablesResult.next() && !found) {
            if (!Objects.equals(tablesResult.getString("TABLE_NAME"), tableName)) continue;
            builder = this.getBasicJdbcTableInfo(tablesResult).withDatabaseName(databaseName);
            found = true;
        }
        if (!found) {
            throw new NoSuchTableException("Table %s does not exist in %s.", new Object[]{tableName, databaseName});
        }
        return builder;
    }

    protected JdbcColumn.Builder getColumnBuilder(ResultSet columnsResult, String databaseName, String tableName) throws SQLException {
        JdbcColumn.Builder builder = null;
        if (Objects.equals(columnsResult.getString("TABLE_NAME"), tableName)) {
            builder = this.getBasicJdbcColumnInfo(columnsResult);
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JdbcTable load(String databaseName, String tableName) throws NoSuchTableException {
        try (Connection connection = this.getConnection(databaseName);){
            ResultSet tables = this.getTable(connection, databaseName, tableName);
            JdbcTable.Builder jdbcTableBuilder = this.getTableBuilder(tables, databaseName, tableName);
            ArrayList<JdbcColumn> jdbcColumns = new ArrayList<JdbcColumn>();
            ResultSet columns = this.getColumns(connection, databaseName, tableName);
            while (columns.next()) {
                JdbcColumn.Builder columnBuilder = this.getColumnBuilder(columns, databaseName, tableName);
                if (columnBuilder == null) continue;
                boolean autoIncrement = this.getAutoIncrementInfo(columns);
                columnBuilder.withAutoIncrement(autoIncrement);
                jdbcColumns.add((JdbcColumn)columnBuilder.build());
            }
            jdbcTableBuilder.withColumns((Column[])jdbcColumns.toArray(new JdbcColumn[0]));
            List<Index> indexes = this.getIndexes(connection, databaseName, tableName);
            jdbcTableBuilder.withIndexes(indexes.toArray(new Index[0]));
            Transform[] tablePartitioning = this.getTablePartitioning(connection, databaseName, tableName);
            jdbcTableBuilder.withPartitioning(tablePartitioning);
            Distribution distribution = this.getDistributionInfo(connection, databaseName, tableName);
            jdbcTableBuilder.withDistribution(distribution);
            Map<String, String> tableProperties = this.getTableProperties(connection, tableName);
            jdbcTableBuilder.withProperties(tableProperties);
            this.correctJdbcTableFields(connection, databaseName, tableName, jdbcTableBuilder);
            JdbcTable jdbcTable = (JdbcTable)jdbcTableBuilder.withTableOperation(this).build();
            return jdbcTable;
        }
        catch (SQLException e) {
            throw this.exceptionMapper.toGravitinoException(e);
        }
    }

    protected Map<String, String> getTableProperties(Connection connection, String tableName) throws SQLException {
        return Collections.emptyMap();
    }

    protected Transform[] getTablePartitioning(Connection connection, String databaseName, String tableName) throws SQLException {
        return Transforms.EMPTY_TRANSFORM;
    }

    protected Distribution getDistributionInfo(Connection connection, String databaseName, String tableName) throws SQLException {
        return Distributions.NONE;
    }

    protected boolean getAutoIncrementInfo(ResultSet resultSet) throws SQLException {
        return resultSet.getBoolean("IS_AUTOINCREMENT");
    }

    @Override
    public void rename(String databaseName, String oldTableName, String newTableName) throws NoSuchTableException {
        LOG.info("Attempting to rename table {}/{} to {}/{}", new Object[]{databaseName, oldTableName, databaseName, newTableName});
        try (Connection connection = this.getConnection(databaseName);){
            JdbcConnectorUtils.executeUpdate(connection, this.generateRenameTableSql(oldTableName, newTableName));
            LOG.info("Renamed table {}/{} to {}/{}", new Object[]{databaseName, oldTableName, databaseName, newTableName});
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    @Override
    public void alterTable(String databaseName, String tableName, TableChange ... changes) throws NoSuchTableException {
        LOG.info("Attempting to alter table {} from database {}", (Object)tableName, (Object)databaseName);
        try (Connection connection = this.getConnection(databaseName);){
            String sql = this.generateAlterTableSql(databaseName, tableName, changes);
            if (StringUtils.isEmpty((CharSequence)sql)) {
                LOG.info("No changes to alter table {} from database {}", (Object)tableName, (Object)databaseName);
                return;
            }
            JdbcConnectorUtils.executeUpdate(connection, sql);
            LOG.info("Alter table {} from database {}", (Object)tableName, (Object)databaseName);
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    @Override
    public boolean purge(String databaseName, String tableName) {
        try {
            this.purgeTable(databaseName, tableName);
        }
        catch (NoSuchSchemaException | NoSuchTableException e) {
            return false;
        }
        return true;
    }

    protected void purgeTable(String databaseName, String tableName) {
        LOG.info("Attempting to purge table {} from database {}", (Object)tableName, (Object)databaseName);
        try (Connection connection = this.getConnection(databaseName);){
            JdbcConnectorUtils.executeUpdate(connection, this.generatePurgeTableSql(tableName));
            LOG.info("Purge table {} from database {}", (Object)tableName, (Object)databaseName);
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    protected void dropTable(String databaseName, String tableName) {
        LOG.info("Attempting to delete table {} from database {}", (Object)tableName, (Object)databaseName);
        try (Connection connection = this.getConnection(databaseName);){
            JdbcConnectorUtils.executeUpdate(connection, this.generateDropTableSql(tableName));
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    protected ResultSet getTables(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String catalogName = connection.getCatalog();
        String schemaName = connection.getSchema();
        return metaData.getTables(catalogName, schemaName, null, JdbcConnectorUtils.getTableTypes());
    }

    protected ResultSet getTable(Connection connection, String databaseName, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getTables(connection.getCatalog(), connection.getSchema(), tableName, null);
    }

    protected ResultSet getColumns(Connection connection, String databaseName, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getColumns(connection.getCatalog(), connection.getSchema(), tableName, null);
    }

    protected void correctJdbcTableFields(Connection connection, String databaseName, String tableName, JdbcTable.Builder jdbcTableBuilder) throws SQLException {
    }

    protected List<Index> getIndexes(Connection connection, String databaseName, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        ArrayList<Index> indexes = new ArrayList<Index>();
        ResultSet primaryKeys = this.getPrimaryKeys(databaseName, tableName, metaData);
        ArrayList<JdbcIndexBean> jdbcIndexBeans = new ArrayList<JdbcIndexBean>();
        while (primaryKeys.next()) {
            jdbcIndexBeans.add(new JdbcIndexBean(Index.IndexType.PRIMARY_KEY, primaryKeys.getString("COLUMN_NAME"), primaryKeys.getString("PK_NAME"), primaryKeys.getInt("KEY_SEQ")));
        }
        Set primaryIndexNames = jdbcIndexBeans.stream().map(JdbcIndexBean::getName).collect(Collectors.toSet());
        ResultSet indexInfo = this.getIndexInfo(databaseName, tableName, metaData);
        while (indexInfo.next()) {
            String indexName = indexInfo.getString("INDEX_NAME");
            String loadedTableName = indexInfo.getString("TABLE_NAME");
            if (!loadedTableName.equals(tableName) || indexInfo.getBoolean("NON_UNIQUE") || primaryIndexNames.contains(indexName)) continue;
            jdbcIndexBeans.add(new JdbcIndexBean(Index.IndexType.UNIQUE_KEY, indexInfo.getString("COLUMN_NAME"), indexName, indexInfo.getInt("ORDINAL_POSITION")));
        }
        Map<Index.IndexType, List<JdbcIndexBean>> indexBeanGroupByIndexType = jdbcIndexBeans.stream().collect(Collectors.groupingBy(JdbcIndexBean::getIndexType));
        for (Map.Entry<Index.IndexType, List<JdbcIndexBean>> entry : indexBeanGroupByIndexType.entrySet()) {
            Map<String, List<JdbcIndexBean>> indexBeanGroupByName = entry.getValue().stream().collect(Collectors.groupingBy(JdbcIndexBean::getName));
            for (Map.Entry<String, List<JdbcIndexBean>> indexEntry : indexBeanGroupByName.entrySet()) {
                List<String> colNames = indexEntry.getValue().stream().sorted(Comparator.comparingInt(JdbcIndexBean::getOrder)).map(JdbcIndexBean::getColName).collect(Collectors.toList());
                String[][] colStrArrays = this.convertIndexFieldNames(colNames);
                if (entry.getKey() == Index.IndexType.PRIMARY_KEY) {
                    indexes.add(Indexes.primary((String)indexEntry.getKey(), (String[][])colStrArrays));
                    continue;
                }
                indexes.add(Indexes.unique((String)indexEntry.getKey(), (String[][])colStrArrays));
            }
        }
        return indexes;
    }

    protected ResultSet getIndexInfo(String databaseName, String tableName, DatabaseMetaData metaData) throws SQLException {
        return metaData.getIndexInfo(databaseName, null, tableName, false, false);
    }

    protected ResultSet getPrimaryKeys(String databaseName, String tableName, DatabaseMetaData metaData) throws SQLException {
        return metaData.getPrimaryKeys(databaseName, null, tableName);
    }

    /*
     * Exception decompiling
     */
    protected String[][] convertIndexFieldNames(List<String> fieldNames) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract String generateCreateTableSql(String var1, JdbcColumn[] var2, String var3, Map<String, String> var4, Transform[] var5, Distribution var6, Index[] var7);

    protected String generateRenameTableSql(String oldTableName, String newTableName) {
        return String.format("RENAME TABLE `%s` TO `%s`", oldTableName, newTableName);
    }

    protected String generateDropTableSql(String tableName) {
        return String.format("DROP TABLE `%s`", tableName);
    }

    protected abstract String generatePurgeTableSql(String var1);

    protected abstract String generateAlterTableSql(String var1, String var2, TableChange ... var3);

    protected JdbcTable getOrCreateTable(String databaseName, String tableName, JdbcTable lazyLoadCreateTable) {
        return null != lazyLoadCreateTable ? lazyLoadCreateTable : this.load(databaseName, tableName);
    }

    protected void validateUpdateColumnNullable(TableChange.UpdateColumnNullability change, JdbcTable table) {
        if (change.fieldName().length > 1) {
            throw new UnsupportedOperationException("Nested column names are not supported");
        }
        String col = change.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(table, col);
        if (!change.nullable() && column.defaultValue().equals(Literals.NULL)) {
            throw new IllegalArgumentException("column " + col + " with null default value cannot be changed to not null");
        }
    }

    protected static void validateIncrementCol(JdbcColumn[] columns, Index[] indexes) {
        List autoIncrementCols = Arrays.stream(columns).filter(Column::autoIncrement).collect(Collectors.toList());
        String autoIncrementColsStr = autoIncrementCols.stream().map(BaseColumn::name).collect(Collectors.joining(",", "[", "]"));
        Preconditions.checkArgument((autoIncrementCols.size() <= 1 ? 1 : 0) != 0, (Object)("Only one column can be auto-incremented. There are multiple auto-increment columns in your table: " + autoIncrementColsStr));
        if (!autoIncrementCols.isEmpty()) {
            Optional<Index> existAutoIncrementColIndexOptional = Arrays.stream(indexes).filter(index -> Arrays.stream(index.fieldNames()).flatMap(Arrays::stream).anyMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)((JdbcColumn)((Object)((Object)((Object)autoIncrementCols.get(0))))).name(), (CharSequence)s))).filter(index -> index.type() == Index.IndexType.PRIMARY_KEY || index.type() == Index.IndexType.UNIQUE_KEY).findAny();
            Preconditions.checkArgument((boolean)existAutoIncrementColIndexOptional.isPresent(), (Object)"Incorrect table definition; there can be only one auto column and it must be defined as a key");
        }
    }

    protected static String getIndexFieldStr(String[][] fieldNames) {
        return Arrays.stream(fieldNames).map(colNames -> {
            if (((String[])colNames).length > 1) {
                throw new IllegalArgumentException("Index does not support complex fields in this Catalog");
            }
            return String.format("`%s`", colNames[0]);
        }).collect(Collectors.joining(", "));
    }

    protected JdbcColumn getJdbcColumnFromTable(JdbcTable jdbcTable, String colName) {
        return (JdbcColumn)Arrays.stream(jdbcTable.columns()).filter(column -> column.name().equals(colName)).findFirst().orElseThrow(() -> new NoSuchColumnException("Column %s does not exist in table %s", new Object[]{colName, jdbcTable.name()}));
    }

    protected Connection getConnection(String catalog) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setCatalog(catalog);
        return connection;
    }

    protected JdbcTable.Builder getBasicJdbcTableInfo(ResultSet table) throws SQLException {
        return (JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)JdbcTable.builder().withName(table.getString("TABLE_NAME"))).withComment(table.getString("REMARKS"))).withAuditInfo(AuditInfo.EMPTY);
    }

    protected JdbcColumn.Builder getBasicJdbcColumnInfo(ResultSet column) throws SQLException {
        JdbcTypeConverter.JdbcTypeBean typeBean = new JdbcTypeConverter.JdbcTypeBean(column.getString("TYPE_NAME"));
        typeBean.setColumnSize(column.getInt("COLUMN_SIZE"));
        typeBean.setScale(column.getInt("DECIMAL_DIGITS"));
        String comment = column.getString("REMARKS");
        boolean nullable = column.getBoolean("NULLABLE");
        String columnDef = column.getString("COLUMN_DEF");
        boolean isExpression = "YES".equals(column.getString("IS_GENERATEDCOLUMN"));
        Expression defaultValue = this.columnDefaultValueConverter.toGravitino(typeBean, columnDef, isExpression, nullable);
        return (JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(column.getString("COLUMN_NAME"))).withType(this.typeConverter.toGravitino(typeBean))).withComment(StringUtils.isEmpty((CharSequence)comment) ? null : comment)).withNullable(nullable)).withDefaultValue(defaultValue);
    }

    private static /* synthetic */ String[][] lambda$convertIndexFieldNames$1(int x$0) {
        return new String[x$0][];
    }
}

