/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaUtil;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public final class KafkaConsumerContextUtil {
    private static final VirtualField<ConsumerRecord<?, ?>, Context> recordContextField = VirtualField.find(ConsumerRecord.class, Context.class);
    private static final VirtualField<ConsumerRecord<?, ?>, String[]> recordConsumerInfoField = VirtualField.find(ConsumerRecord.class, String[].class);
    private static final VirtualField<ConsumerRecords<?, ?>, Context> recordsContextField = VirtualField.find(ConsumerRecords.class, Context.class);
    private static final VirtualField<ConsumerRecords<?, ?>, String[]> recordsConsumerInfoField = VirtualField.find(ConsumerRecords.class, String[].class);

    public static KafkaConsumerContext get(ConsumerRecord<?, ?> records) {
        Context receiveContext = (Context)recordContextField.get(records);
        String consumerGroup = null;
        String clientId = null;
        String[] consumerInfo = (String[])recordConsumerInfoField.get(records);
        if (consumerInfo != null) {
            consumerGroup = consumerInfo[0];
            clientId = consumerInfo[1];
        }
        return KafkaConsumerContextUtil.create(receiveContext, consumerGroup, clientId);
    }

    public static KafkaConsumerContext get(ConsumerRecords<?, ?> records) {
        Context receiveContext = (Context)recordsContextField.get(records);
        String consumerGroup = null;
        String clientId = null;
        String[] consumerInfo = (String[])recordsConsumerInfoField.get(records);
        if (consumerInfo != null) {
            consumerGroup = consumerInfo[0];
            clientId = consumerInfo[1];
        }
        return KafkaConsumerContextUtil.create(receiveContext, consumerGroup, clientId);
    }

    public static KafkaConsumerContext create(Context context, Consumer<?, ?> consumer) {
        return KafkaConsumerContextUtil.create(context, KafkaUtil.getConsumerGroup(consumer), KafkaUtil.getClientId(consumer));
    }

    public static KafkaConsumerContext create(Context context, String consumerGroup, String clientId) {
        return KafkaConsumerContext.create(context, consumerGroup, clientId);
    }

    public static void set(ConsumerRecord<?, ?> record, Context context, Consumer<?, ?> consumer) {
        recordContextField.set(record, (Object)context);
        String consumerGroup = KafkaUtil.getConsumerGroup(consumer);
        String clientId = KafkaUtil.getClientId(consumer);
        KafkaConsumerContextUtil.set(record, context, consumerGroup, clientId);
    }

    public static void set(ConsumerRecord<?, ?> record, KafkaConsumerContext consumerContext) {
        KafkaConsumerContextUtil.set(record, consumerContext.getContext(), consumerContext.getConsumerGroup(), consumerContext.getClientId());
    }

    public static void set(ConsumerRecord<?, ?> record, Context context, String consumerGroup, String clientId) {
        recordContextField.set(record, (Object)context);
        recordConsumerInfoField.set(record, (Object)new String[]{consumerGroup, clientId});
    }

    public static void set(ConsumerRecords<?, ?> records, Context context, Consumer<?, ?> consumer) {
        String consumerGroup = KafkaUtil.getConsumerGroup(consumer);
        String clientId = KafkaUtil.getClientId(consumer);
        KafkaConsumerContextUtil.set(records, context, consumerGroup, clientId);
    }

    public static void set(ConsumerRecords<?, ?> records, Context context, String consumerGroup, String clientId) {
        recordsContextField.set(records, (Object)context);
        recordsConsumerInfoField.set(records, (Object)new String[]{consumerGroup, clientId});
    }

    public static void copy(ConsumerRecord<?, ?> from, ConsumerRecord<?, ?> to) {
        recordContextField.set(to, (Object)((Context)recordContextField.get(from)));
        recordConsumerInfoField.set(to, (Object)((String[])recordConsumerInfoField.get(from)));
    }

    private KafkaConsumerContextUtil() {
    }
}

