/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.AbstractStaticWeaveOutputHandler;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class StaticWeaveDirectoryOutputHandler
extends AbstractStaticWeaveOutputHandler {
    private URL source = null;
    private URL target = null;

    public StaticWeaveDirectoryOutputHandler(URL source, URL target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public void addDirEntry(String dirPath) throws IOException {
        File file = new File(this.target.getPath() + File.separator + dirPath).getAbsoluteFile();
        if (!file.exists() && !file.mkdirs()) {
            AbstractSessionLog.getLog().log(3, "weaver", (Object)ToStringLocalization.buildMessage((String)"staticweave_processor_dir_not_created", (Object[])new Object[]{file}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(JarEntry targetEntry, byte[] entryBytes) throws IOException {
        FileOutputStream fos = null;
        try {
            File target = new File(this.target.getPath() + targetEntry.getName()).getAbsoluteFile();
            if (!target.exists() && !target.createNewFile()) {
                AbstractSessionLog.getLog().log(3, "weaver", (Object)ToStringLocalization.buildMessage((String)"staticweave_processor_file_not_created", (Object[])new Object[]{target}));
            }
            fos = new FileOutputStream(target);
            fos.write(entryBytes);
        }
        catch (Throwable throwable) {
            Helper.close(fos);
            throw throwable;
        }
        Helper.close((Closeable)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(InputStream jis, JarEntry entry) throws IOException, URISyntaxException {
        File target = new File(this.target.getPath() + entry.getName()).getAbsoluteFile();
        if (!target.exists() && !target.createNewFile()) {
            AbstractSessionLog.getLog().log(3, "weaver", (Object)ToStringLocalization.buildMessage((String)"staticweave_processor_file_not_created", (Object[])new Object[]{target}));
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            if (new File(Helper.toURI((URL)this.source)).isDirectory()) {
                File sourceEntry = new File(this.source.getPath() + entry.getName());
                fis = new FileInputStream(sourceEntry);
                byte[] classBytes = new byte[fis.available()];
                fis.read(classBytes);
                fos = new FileOutputStream(target);
                fos.write(classBytes);
            } else {
                this.readwriteStreams(jis, new FileOutputStream(target));
            }
        }
        finally {
            Helper.close(fis);
            Helper.close(fos);
        }
    }
}

