/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.alert.dto.PrometheusExternAlert;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PrometheusExternAlertService
implements ExternAlertService {
    private static final Logger log = LoggerFactory.getLogger(PrometheusExternAlertService.class);
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public void addExternAlert(String content) {
        TypeReference<List<PrometheusExternAlert>> typeReference = new TypeReference<List<PrometheusExternAlert>>(){};
        List alerts = (List)JsonUtil.fromJson((String)content, (TypeReference)typeReference);
        if (alerts == null || alerts.isEmpty()) {
            log.warn("parse prometheus extern alert content failed! content: {}", (Object)content);
            return;
        }
        for (PrometheusExternAlert alert : alerts) {
            Map<String, String> labels;
            String description;
            Map<String, String> annotations = alert.getAnnotations();
            if (annotations == null) {
                annotations = new HashMap<String, String>(8);
            }
            if (StringUtils.hasText((String)alert.getGeneratorURL())) {
                annotations.put("generatorURL", alert.getGeneratorURL());
            }
            if ((description = annotations.get("description")) == null) {
                description = annotations.get("summary");
            }
            if (description == null) {
                description = annotations.values().stream().findFirst().orElse("");
            }
            if ((labels = alert.getLabels()) == null) {
                labels = new HashMap<String, String>(8);
            }
            labels.put("__source__", "prometheus");
            String status = "firing";
            if (alert.getEndsAt() != null && alert.getEndsAt().isBefore(Instant.now())) {
                status = "resolved";
            }
            SingleAlert singleAlert = SingleAlert.builder().content(description).status(status).activeAt("firing".equals(status) ? Long.valueOf(Instant.now().toEpochMilli()) : null).startAt(Long.valueOf(alert.getStartsAt() != null ? alert.getStartsAt().toEpochMilli() : Instant.now().toEpochMilli())).endAt("resolved".equals(status) ? Long.valueOf(alert.getEndsAt().toEpochMilli()) : null).labels(labels).annotations(alert.getAnnotations()).triggerTimes(Integer.valueOf(1)).build();
            this.alarmCommonReduce.reduceAndSendAlarm(singleAlert);
        }
    }

    @Override
    public String supportSource() {
        return "prometheus";
    }
}

