/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramGauges;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.micrometer.v1_5.DistributionStatisticConfigModifier;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryCounter;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryDistributionSummary;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryFunctionCounter;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryFunctionTimer;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryGauge;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryLongTaskTimer;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryMeter;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryMeterRegistryBuilder;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryTimer;
import io.opentelemetry.instrumentation.micrometer.v1_5.RemovableMeter;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;

public final class OpenTelemetryMeterRegistry
extends MeterRegistry {
    private final TimeUnit baseTimeUnit;
    private final DistributionStatisticConfigModifier distributionStatisticConfigModifier;
    private final io.opentelemetry.api.metrics.Meter otelMeter;

    public static MeterRegistry create(OpenTelemetry openTelemetry) {
        return OpenTelemetryMeterRegistry.builder(openTelemetry).build();
    }

    public static OpenTelemetryMeterRegistryBuilder builder(OpenTelemetry openTelemetry) {
        return new OpenTelemetryMeterRegistryBuilder(openTelemetry);
    }

    OpenTelemetryMeterRegistry(Clock clock, TimeUnit baseTimeUnit, NamingConvention namingConvention, DistributionStatisticConfigModifier distributionStatisticConfigModifier, io.opentelemetry.api.metrics.Meter otelMeter) {
        super(clock);
        this.baseTimeUnit = baseTimeUnit;
        this.distributionStatisticConfigModifier = distributionStatisticConfigModifier;
        this.otelMeter = otelMeter;
        this.config().namingConvention(namingConvention).onMeterRemoved(OpenTelemetryMeterRegistry::onMeterRemoved);
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new OpenTelemetryGauge<T>(id, this.config().namingConvention(), obj, valueFunction, this.otelMeter);
    }

    protected Counter newCounter(Meter.Id id) {
        return new OpenTelemetryCounter(id, this.config().namingConvention(), this.otelMeter);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        OpenTelemetryLongTaskTimer timer = new OpenTelemetryLongTaskTimer(id, this.config().namingConvention(), this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, this.otelMeter);
        if (timer.isUsingMicrometerHistograms()) {
            HistogramGauges.registerWithCommonFormat((LongTaskTimer)timer, (MeterRegistry)this);
        }
        return timer;
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        OpenTelemetryTimer timer = new OpenTelemetryTimer(id, this.config().namingConvention(), this.clock, distributionStatisticConfig, this.distributionStatisticConfigModifier, pauseDetector, this.getBaseTimeUnit(), this.otelMeter);
        if (timer.isUsingMicrometerHistograms()) {
            HistogramGauges.registerWithCommonFormat((Timer)timer, (MeterRegistry)this);
        }
        return timer;
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        OpenTelemetryDistributionSummary distributionSummary = new OpenTelemetryDistributionSummary(id, this.config().namingConvention(), this.clock, distributionStatisticConfig, this.distributionStatisticConfigModifier, scale, this.otelMeter);
        if (distributionSummary.isUsingMicrometerHistograms()) {
            HistogramGauges.registerWithCommonFormat((DistributionSummary)distributionSummary, (MeterRegistry)this);
        }
        return distributionSummary;
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new OpenTelemetryMeter(id, this.config().namingConvention(), measurements, this.otelMeter);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new OpenTelemetryFunctionTimer<T>(id, this.config().namingConvention(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit(), this.otelMeter);
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new OpenTelemetryFunctionCounter<T>(id, this.config().namingConvention(), obj, countFunction, this.otelMeter);
    }

    protected TimeUnit getBaseTimeUnit() {
        return this.baseTimeUnit;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.DEFAULT;
    }

    private static void onMeterRemoved(Meter meter) {
        if (meter instanceof RemovableMeter) {
            ((RemovableMeter)meter).onRemove();
        }
    }
}

