/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.hertzbeat.alert.expr.AlertExpressionEvalVisitor;
import org.apache.hertzbeat.alert.expr.AlertExpressionLexer;
import org.apache.hertzbeat.alert.expr.AlertExpressionParser;
import org.apache.hertzbeat.alert.service.DataSourceService;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DataSourceServiceImpl
implements DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    @Autowired(required=false)
    private List<QueryExecutor> executors;
    private final Cache<String, ParseTree> expressionCache = Caffeine.newBuilder().maximumSize(256L).expireAfterAccess(1L, TimeUnit.HOURS).recordStats().build();
    private final Cache<String, CommonTokenStream> tokenStreamCache = Caffeine.newBuilder().maximumSize(512L).expireAfterWrite(30L, TimeUnit.MINUTES).recordStats().build();

    @Override
    public List<Map<String, Object>> calculate(String datasource, String expr) {
        if (!StringUtils.hasText((String)expr)) {
            throw new IllegalArgumentException("Empty expression");
        }
        if (this.executors == null || this.executors.isEmpty()) {
            throw new IllegalArgumentException("No query executor found");
        }
        QueryExecutor executor = this.executors.stream().filter(e -> e.support(datasource)).findFirst().orElse(null);
        if (executor == null) {
            throw new IllegalArgumentException("Unsupported datasource: " + datasource);
        }
        expr = expr.replaceAll("\\s+", " ");
        try {
            return this.evaluate(expr, executor);
        }
        catch (Exception e2) {
            log.error("Error executing query on datasource {}: {}", (Object)datasource, (Object)e2.getMessage());
            throw new RuntimeException("Query execution failed", e2);
        }
    }

    private List<Map<String, Object>> evaluate(String expr, QueryExecutor executor) {
        CommonTokenStream tokens = (CommonTokenStream)this.tokenStreamCache.get((Object)expr, this::createTokenStream);
        AlertExpressionParser parser = new AlertExpressionParser((TokenStream)tokens);
        ParseTree tree = (ParseTree)this.expressionCache.get((Object)expr, e -> parser.expr());
        AlertExpressionEvalVisitor visitor = new AlertExpressionEvalVisitor(executor, tokens);
        return (List)visitor.visit(tree);
    }

    private CommonTokenStream createTokenStream(String expr) {
        AlertExpressionLexer lexer = new AlertExpressionLexer((CharStream)CharStreams.fromString((String)expr));
        return new CommonTokenStream((TokenSource)lexer);
    }

    public void setExecutors(List<QueryExecutor> executors) {
        this.executors = executors;
    }

    public Cache<String, ParseTree> getExpressionCache() {
        return this.expressionCache;
    }

    public Cache<String, CommonTokenStream> getTokenStreamCache() {
        return this.tokenStreamCache;
    }
}

