/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.mybatisplus;

import com.xiaomi.youpin.docean.plugin.mybatisplus.MybatisTransaction;
import com.xiaomi.youpin.docean.plugin.mybatisplus.TransactionalContext;
import java.sql.Connection;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;

public class MybatisSessionFactory
implements SqlSessionFactory {
    private final Configuration configuration;
    private SqlSessionFactory sqlSessionFactory;

    public MybatisSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        this.configuration = this.sqlSessionFactory.getConfiguration();
    }

    public SqlSession openSession() {
        return this.openSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlSession openSession(boolean autoCommit) {
        try {
            Environment environment = this.configuration.getEnvironment();
            MybatisTransaction tx = null;
            if (TransactionalContext.getContext().get() != null) {
                MybatisTransaction _tx = TransactionalContext.getContext().get();
                _tx.setDataSource(environment.getDataSource());
                tx = _tx;
            } else {
                TransactionFactory transactionFactory = this.getTransactionFactoryFromEnvironment(environment);
                tx = transactionFactory.newTransaction(environment.getDataSource(), null, autoCommit);
            }
            Executor executor = this.configuration.newExecutor((Transaction)tx, this.configuration.getDefaultExecutorType());
            DefaultSqlSession defaultSqlSession = new DefaultSqlSession(this.configuration, executor, autoCommit);
            return defaultSqlSession;
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    private TransactionFactory getTransactionFactoryFromEnvironment(Environment environment) {
        if (environment == null || environment.getTransactionFactory() == null) {
            return new ManagedTransactionFactory();
        }
        return environment.getTransactionFactory();
    }

    public SqlSession openSession(Connection connection) {
        return null;
    }

    public SqlSession openSession(TransactionIsolationLevel level) {
        return null;
    }

    public SqlSession openSession(ExecutorType execType) {
        return null;
    }

    public SqlSession openSession(ExecutorType execType, boolean autoCommit) {
        return null;
    }

    public SqlSession openSession(ExecutorType execType, TransactionIsolationLevel level) {
        return null;
    }

    public SqlSession openSession(ExecutorType execType, Connection connection) {
        return null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

