/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel;

import cn.hutool.core.lang.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.xiaomi.data.push.common.SafeRun;
import com.xiaomi.data.push.rpc.RpcClient;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.mone.file.ILogFile;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Lookup;
import com.xiaomi.youpin.docean.anno.Service;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.agent.channel.AbstractChannelService;
import org.apache.ozhera.log.agent.channel.ChannelDefine;
import org.apache.ozhera.log.agent.channel.ChannelService;
import org.apache.ozhera.log.agent.channel.ChannelServiceImpl;
import org.apache.ozhera.log.agent.channel.ChannelState;
import org.apache.ozhera.log.agent.channel.WildcardChannelServiceImpl;
import org.apache.ozhera.log.agent.channel.comparator.AppSimilarComparator;
import org.apache.ozhera.log.agent.channel.comparator.FilterSimilarComparator;
import org.apache.ozhera.log.agent.channel.comparator.InputSimilarComparator;
import org.apache.ozhera.log.agent.channel.comparator.OutputSimilarComparator;
import org.apache.ozhera.log.agent.channel.listener.DefaultFileMonitorListener;
import org.apache.ozhera.log.agent.channel.listener.FileMonitorListener;
import org.apache.ozhera.log.agent.channel.locator.ChannelDefineJsonLocator;
import org.apache.ozhera.log.agent.channel.locator.ChannelDefineLocator;
import org.apache.ozhera.log.agent.channel.locator.ChannelDefineRpcLocator;
import org.apache.ozhera.log.agent.channel.memory.AgentMemoryService;
import org.apache.ozhera.log.agent.channel.memory.AgentMemoryServiceImpl;
import org.apache.ozhera.log.agent.common.ExecutorUtil;
import org.apache.ozhera.log.agent.export.MsgExporter;
import org.apache.ozhera.log.agent.factory.OutPutServiceFactory;
import org.apache.ozhera.log.agent.filter.FilterChain;
import org.apache.ozhera.log.agent.input.Input;
import org.apache.ozhera.log.agent.output.Output;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.api.model.vo.UpdateLogProcessCmd;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class ChannelEngine {
    private static final Logger log = LoggerFactory.getLogger(ChannelEngine.class);
    private AgentMemoryService agentMemoryService;
    private ChannelDefineLocator channelDefineLocator;
    private List<ChannelDefine> channelDefineList = Lists.newArrayList();
    private volatile List<ChannelService> channelServiceList = Lists.newArrayList();
    private FileMonitorListener fileMonitorListener;
    private String memoryBasePath;
    private Gson gson = Constant.GSON;
    private volatile boolean initComplete;

    @Lookup(value="$logFile")
    public ILogFile logFile() {
        return null;
    }

    public void init() {
        ArrayList failedChannelId = Lists.newArrayList();
        try {
            com.xiaomi.youpin.docean.plugin.config.Config config = (com.xiaomi.youpin.docean.plugin.config.Config)Ioc.ins().getBean(com.xiaomi.youpin.docean.plugin.config.Config.class.getName());
            this.memoryBasePath = config.get("agent.memory.path", "/tmp/");
            this.channelDefineLocator = this.getChannelDefineLocator(config);
            this.channelDefineList = new CopyOnWriteArrayList<ChannelDefine>(this.channelDefineLocator.getChannelDefine());
            log.info("current agent all config meta:{}", (Object)this.gson.toJson(this.channelDefineList));
            this.agentMemoryService = new AgentMemoryServiceImpl(this.memoryBasePath);
            this.fileMonitorListener = new DefaultFileMonitorListener();
            log.info("query channelDefineList:{}", (Object)this.gson.toJson(this.channelDefineList));
            this.channelServiceList = this.channelDefineList.stream().filter(channelDefine -> this.filterCollStart(channelDefine.getAppName())).map(channelDefine -> {
                ChannelService channelService = this.channelServiceTrans((ChannelDefine)channelDefine);
                if (null == channelService) {
                    failedChannelId.add(channelDefine.getChannelId());
                }
                return channelService;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.deleteFailedChannel(failedChannelId, this.channelDefineList, this.channelServiceList);
            this.channelServiceList = new CopyOnWriteArrayList<ChannelService>(this.channelServiceList);
            this.channelStart(this.channelServiceList);
            this.graceShutdown();
            this.exportChannelState();
            log.info("current channelDefineList:{},current channelServiceList:{}", (Object)this.gson.toJson(this.channelDefineList), (Object)this.gson.toJson(this.channelServiceList.stream().map(ChannelService::instanceId).collect(Collectors.toList())));
            this.monitorFilesClean();
            this.executorFileClean();
        }
        catch (Exception e) {
            log.error("ChannelEngine init exception", (Throwable)e);
        }
        finally {
            this.initComplete = true;
        }
    }

    private void executorFileClean() {
        ExecutorUtil.scheduleAtFixedRate(() -> SafeRun.run(() -> {
            List<Object> serviceTimeList = Lists.newArrayList();
            for (ChannelService channelService : this.channelServiceList) {
                AbstractChannelService service = (AbstractChannelService)channelService;
                Map<String, Long> fileReadTime = service.getExpireFileMap();
                if (fileReadTime.isEmpty()) continue;
                for (Map.Entry<String, Long> entry : fileReadTime.entrySet()) {
                    serviceTimeList.add(Pair.of((Object)service, (Object)Pair.of((Object)entry.getKey(), (Object)entry.getValue())));
                }
            }
            if (serviceTimeList.size() > 500) {
                serviceTimeList = serviceTimeList.stream().sorted(Comparator.comparing(o -> (Long)((Pair)o.getValue()).getValue())).collect(Collectors.toList());
                for (int i = 0; i < serviceTimeList.size(); ++i) {
                    if (i >= 100) continue;
                    ((AbstractChannelService)((Pair)serviceTimeList.get(i)).getKey()).cancelFile((String)((Pair)((Pair)serviceTimeList.get(i)).getValue()).getKey());
                }
            }
        }), 1L, 10L, TimeUnit.MINUTES);
    }

    private void monitorFilesClean() {
        ExecutorUtil.scheduleAtFixedRate(() -> {
            for (ChannelService channelService : this.channelServiceList) {
                try {
                    channelService.cleanCollectFiles();
                }
                catch (Exception e) {
                    log.error("monitorFilesClean error", (Throwable)e);
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private ChannelDefineLocator getChannelDefineLocator(com.xiaomi.youpin.docean.plugin.config.Config config) {
        String locatorType = config.get("agent.channel.locator", "rpc");
        log.warn("locatorType: {}", (Object)locatorType);
        switch (locatorType) {
            case "json": {
                return new ChannelDefineJsonLocator();
            }
        }
        return new ChannelDefineRpcLocator();
    }

    private void exportChannelState() {
        ExecutorUtil.scheduleAtFixedRate(() -> SafeRun.run(() -> {
            List<ChannelState> channelStateList = this.channelServiceList.stream().map(c -> c.state()).collect(Collectors.toList());
            this.sendCollectionProgress(channelStateList);
        }), 10L, 10L, TimeUnit.SECONDS);
    }

    private List<Long> channelStart(List<ChannelService> channelServiceList) {
        ArrayList failedChannelIds = Lists.newArrayList();
        ArrayList successChannelIds = Lists.newArrayList();
        for (ChannelService channelService : channelServiceList) {
            AbstractChannelService abstractChannelService = (AbstractChannelService)channelService;
            Long channelId = abstractChannelService.getChannelDefine().getChannelId();
            log.info("realChannelService,id:{}", (Object)channelId);
            try {
                channelService.start();
                this.fileMonitorListener.addChannelService(channelService);
                successChannelIds.add(channelId);
            }
            catch (RejectedExecutionException e) {
                log.error("The thread pool is full.id:{}", (Object)channelId, (Object)e);
            }
            catch (Exception e) {
                failedChannelIds.add(channelId);
                log.error("start channel exception,channelId:{}", (Object)channelId, (Object)e);
            }
        }
        this.deleteFailedChannel(failedChannelIds, this.channelDefineList, this.channelServiceList);
        return successChannelIds;
    }

    private void deleteFailedChannel(List<Long> failedChannelId, List<ChannelDefine> defineList, List<ChannelService> serviceList) {
        if (CollectionUtils.isNotEmpty(failedChannelId)) {
            for (Long delChannelId : failedChannelId) {
                defineList.removeIf(channelDefine -> Objects.equals(delChannelId, channelDefine.getChannelId()));
                serviceList.removeIf(channelService -> Objects.equals(delChannelId, ((AbstractChannelService)channelService).getChannelDefine().getChannelId()));
            }
        }
    }

    private void graceShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("shutdown hook begin!");
            for (ChannelService c : this.channelServiceList) {
                try {
                    c.close();
                }
                catch (Exception e) {
                    log.error("shutdown channel exception:{}", (Throwable)e);
                }
            }
            log.info("shutdown hook end!");
        }));
    }

    private ChannelService channelServiceTrans(ChannelDefine channelDefine) {
        try {
            Input input;
            boolean matchWildcard;
            this.preCheckChannelDefine(channelDefine);
            Output output = channelDefine.getOutput();
            MsgExporter exporter = this.exporterTrans(output);
            if (null == exporter) {
                throw new IllegalArgumentException("cant not trans to MsgExporter, output:" + this.gson.toJson((Object)output));
            }
            FilterChain filterChain = new FilterChain();
            filterChain.loadFilterList(channelDefine.getFilters());
            filterChain.reset();
            if (null == this.agentMemoryService) {
                this.agentMemoryService = new AgentMemoryServiceImpl(Config.ins().get("agent.memory.path", "/tmp/"));
            }
            AbstractChannelService channelService = (matchWildcard = Arrays.stream((input = channelDefine.getInput()).getLogPattern().split(",")).anyMatch(data -> StringUtils.substringAfterLast((String)data, (String)"/").contains("*"))) ? new WildcardChannelServiceImpl(exporter, this.agentMemoryService, channelDefine, filterChain, this.memoryBasePath) : new ChannelServiceImpl(exporter, this.agentMemoryService, channelDefine, filterChain);
            return channelService;
        }
        catch (Throwable e) {
            log.error("channelServiceTrans exception, channelDefine:{}, exception:{}", (Object)this.gson.toJson((Object)channelDefine), (Object)e);
            return null;
        }
    }

    private void preCheckChannelDefine(ChannelDefine channelDefine) {
        Preconditions.checkArgument((null != channelDefine ? 1 : 0) != 0, (Object)"channelDefine can not be null");
        Preconditions.checkArgument((null != channelDefine.getInput() ? 1 : 0) != 0, (Object)"channelDefine.input can not be null");
        Preconditions.checkArgument((null != channelDefine.getOutput() ? 1 : 0) != 0, (Object)"channelDefine.output can not be null");
        Preconditions.checkArgument((null != channelDefine.getChannelId() ? 1 : 0) != 0, (Object)"channelDefine.channelId can not be null");
        this.preCheckOutput(channelDefine.getOutput());
        Input input = channelDefine.getInput();
        String logPattern = input.getLogPattern();
        Preconditions.checkArgument((null != logPattern ? 1 : 0) != 0, (Object)"channelDefine.logPattern can not be null");
    }

    private void preCheckOutput(Output output) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)output.getOutputType()), (Object)"outputType can not be null");
        OutPutServiceFactory.getOutPutService(output.getServiceName()).preCheckOutput(output);
    }

    private MsgExporter exporterTrans(Output output) throws Exception {
        if (null == output) {
            return null;
        }
        return OutPutServiceFactory.getOutPutService(output.getServiceName()).exporterTrans(output);
    }

    public void refresh(List<ChannelDefine> channelDefines) {
        log.info("[config change],changed data:{},origin data:{}", (Object)this.gson.toJson(channelDefines), (Object)this.gson.toJson(this.channelDefineList));
        try {
            if (CollectionUtils.isNotEmpty(channelDefines) && !CollectionUtils.isEqualCollection(channelDefines, this.channelDefineList)) {
                if (channelDefines.stream().allMatch(channelDefine -> null != channelDefine.getOperateEnum() && channelDefine.getOperateEnum().getCode().equals(OperateEnum.STOP_OPERATE.getCode()))) {
                    log.info("stopSpecialFileColl,config:{}", (Object)this.gson.toJson(channelDefines));
                    this.delSpecialFileColl(channelDefines);
                    return;
                }
                if (channelDefines.stream().allMatch(channelDefine -> null != channelDefine.getOperateEnum() && channelDefine.getOperateEnum().getCode().equals(OperateEnum.DELETE_OPERATE.getCode()))) {
                    log.info("delSpecialFileColl,config:{}", (Object)this.gson.toJson(channelDefines));
                    this.deleteConfig(channelDefines, false);
                    return;
                }
                log.info("refresh,config:{}", (Object)this.gson.toJson(channelDefines));
                this.addConfig(channelDefines, false);
                this.updateConfig(channelDefines);
                if (channelDefines.size() == 1 && channelDefines.get(0).getSingleMetaData() != null && channelDefines.get(0).getSingleMetaData().booleanValue()) {
                    return;
                }
                this.deleteConfig(channelDefines, false);
            }
        }
        catch (Exception e) {
            log.error("refresh error,[config change],changed data:{},origin data:{}", new Object[]{this.gson.toJson(channelDefines), this.gson.toJson(this.channelDefineList), e});
        }
    }

    private void addConfig(List<ChannelDefine> channelDefines, boolean directAdd) {
        try {
            List<ChannelDefine> channelDefinesDifference = this.differenceSet(channelDefines, this.channelDefineList);
            if (directAdd) {
                channelDefinesDifference = channelDefines;
            }
            if (directAdd || CollectionUtils.isNotEmpty(channelDefinesDifference)) {
                log.info("[add config]data:{}", (Object)this.gson.toJson(channelDefinesDifference));
                this.initIncrement(channelDefinesDifference);
            }
        }
        catch (Exception e) {
            log.error("addConfig error,source channelDefines:{},origin channelDefines:{},directAdd:{}", new Object[]{this.gson.toJson(channelDefines), this.gson.toJson(this.channelDefineList), directAdd, e});
        }
    }

    private void updateConfig(List<ChannelDefine> channelDefines) {
        List<ChannelDefine> channelDefinesIntersection = this.intersection(channelDefines, this.channelDefineList);
        if (CollectionUtils.isNotEmpty(channelDefinesIntersection)) {
            ArrayList changedDefines = Lists.newArrayList();
            log.info("have exist config:{}", (Object)Constant.GSON.toJson(this.channelDefineList));
            for (ChannelDefine newChannelDefine : channelDefinesIntersection) {
                Long channelId = newChannelDefine.getChannelId();
                ChannelDefine oldChannelDefine = this.channelDefineList.stream().filter(channelDefine -> channelDefine.getChannelId().equals(channelId)).findFirst().orElse(null);
                if (null == oldChannelDefine) continue;
                AppSimilarComparator appSimilarComparator = new AppSimilarComparator(oldChannelDefine.getAppId());
                InputSimilarComparator inputSimilarComparator = new InputSimilarComparator(oldChannelDefine.getInput());
                OutputSimilarComparator outputSimilarComparator = new OutputSimilarComparator(oldChannelDefine.getOutput());
                FilterSimilarComparator filterSimilarComparator = new FilterSimilarComparator(oldChannelDefine.getFilters());
                if (appSimilarComparator.compare(newChannelDefine.getAppId()) && inputSimilarComparator.compare(newChannelDefine.getInput()) && outputSimilarComparator.compare(newChannelDefine.getOutput())) {
                    if (filterSimilarComparator.compare(newChannelDefine.getFilters())) continue;
                    this.channelServiceList.stream().filter(channelService -> ((AbstractChannelService)channelService).getChannelDefine().getChannelId().equals(channelId)).findFirst().ifPresent(channelService -> channelService.filterRefresh(newChannelDefine.getFilters()));
                    continue;
                }
                log.info("config changed,old:{},new:{}", (Object)this.gson.toJson((Object)oldChannelDefine), (Object)this.gson.toJson((Object)newChannelDefine));
                changedDefines.add(newChannelDefine);
                this.deleteConfig(Arrays.asList(newChannelDefine), true);
                this.addConfig(Arrays.asList(newChannelDefine), true);
            }
            if (CollectionUtils.isNotEmpty((Collection)changedDefines)) {
                log.info("[update config]data:{}", (Object)this.gson.toJson((Object)changedDefines));
            }
        }
    }

    private void deleteConfig(List<ChannelDefine> channelDefines, boolean directDel) {
        this.delTailFileColl(channelDefines, directDel);
    }

    private void delTailFileColl(List<ChannelDefine> channelDefines, boolean directDel) {
        List<Object> channelDels = channelDefines.stream().filter(channelDefine -> null != channelDefine.getOperateEnum() && channelDefine.getOperateEnum().getCode().equals(OperateEnum.DELETE_OPERATE.getCode()) && StringUtils.isEmpty((CharSequence)channelDefine.getDelDirectory())).collect(Collectors.toList());
        if (directDel) {
            channelDels = channelDefines;
        }
        try {
            if (directDel || CollectionUtils.isNotEmpty(channelDels)) {
                log.info("[delete config]data:{}", (Object)this.gson.toJson(channelDels));
                List channelIdDels = channelDels.stream().map(ChannelDefine::getChannelId).collect(Collectors.toList());
                ArrayList tempChannelServiceList = Lists.newArrayList();
                this.channelServiceList.forEach(channelService -> {
                    Long channelId = ((AbstractChannelService)channelService).getChannelDefine().getChannelId();
                    if (channelIdDels.contains(channelId)) {
                        log.info("[delete config]channelService:{}", (Object)channelId);
                        channelService.close();
                        this.fileMonitorListener.removeChannelService((ChannelService)channelService);
                        tempChannelServiceList.add(channelService);
                        this.channelDefineList.removeIf(channelDefine -> {
                            if (channelDefine.getChannelId().equals(channelId)) {
                                Output output = channelDefine.getOutput();
                                OutPutServiceFactory.getOutPutService(output.getServiceName()).removeMQ(output);
                                return true;
                            }
                            return false;
                        });
                    }
                });
                if (CollectionUtils.isNotEmpty((Collection)tempChannelServiceList)) {
                    this.channelServiceList.removeAll(tempChannelServiceList);
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("delete config exception,config:%s", this.gson.toJson(channelDels)), (Throwable)e);
        }
    }

    private void delSpecialFileColl(List<ChannelDefine> channelDefines) {
        List delSpecialFiles = channelDefines.stream().filter(channelDefine -> null != channelDefine.getOperateEnum() && channelDefine.getOperateEnum().getCode().equals(OperateEnum.DELETE_OPERATE.getCode()) && StringUtils.isNotEmpty((CharSequence)channelDefine.getDelDirectory())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(delSpecialFiles)) {
            try {
                for (ChannelService channelService : this.channelServiceList) {
                    CompletableFuture.runAsync(() -> {
                        AbstractChannelService abstractChannelService = (AbstractChannelService)channelService;
                        Long channelId = abstractChannelService.getChannelDefine().getChannelId();
                        List defineList = delSpecialFiles.stream().filter(channelDefine -> Objects.equals(channelDefine.getChannelId(), channelId)).collect(Collectors.toList());
                        for (ChannelDefine channelDefine2 : defineList) {
                            log.info("deleteConfig,deleteCollFile,channelDefine:{}", (Object)this.gson.toJson((Object)channelDefine2));
                            channelService.deleteCollFile(channelDefine2.getDelDirectory());
                        }
                        if (LogTypeEnum.OPENTELEMETRY == abstractChannelService.getLogTypeEnum()) {
                            for (ChannelDefine channelDefine2 : delSpecialFiles) {
                                log.info("deleteConfig OPENTELEMETRY,deleteCollFile,channelDefine:{}", (Object)this.gson.toJson((Object)channelDefine2));
                                channelService.deleteCollFile(channelDefine2.getDelDirectory());
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error("delSpecialFileColl error,delSpecialFiles:{}", (Object)this.gson.toJson(channelDefines), (Object)e);
            }
        }
    }

    private List<ChannelDefine> differenceSet(List<ChannelDefine> origin, List<ChannelDefine> source) {
        if (CollectionUtils.isEmpty(source)) {
            return origin;
        }
        List sourceIds = source.stream().map(ChannelDefine::getChannelId).collect(Collectors.toList());
        return origin.stream().filter(channelDefine -> !sourceIds.contains(channelDefine.getChannelId()) && OperateEnum.DELETE_OPERATE != channelDefine.getOperateEnum()).collect(Collectors.toList());
    }

    private List<ChannelDefine> intersection(List<ChannelDefine> origin, List<ChannelDefine> source) {
        List<Object> sourceIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(source)) {
            sourceIds = source.stream().map(ChannelDefine::getChannelId).collect(Collectors.toList());
        }
        ArrayList finalSourceIds = sourceIds;
        return origin.stream().filter(channelDefine -> finalSourceIds.contains(channelDefine.getChannelId()) && OperateEnum.DELETE_OPERATE != channelDefine.getOperateEnum()).collect(Collectors.toList());
    }

    public void initIncrement(List<ChannelDefine> definesIncrement) {
        ArrayList failedChannelId = Lists.newArrayList();
        List<ChannelService> channelServices = definesIncrement.stream().filter(Objects::nonNull).filter(channelDefine -> this.filterCollStart(channelDefine.getAppName())).map(channelDefine -> {
            ChannelService channelService = this.channelServiceTrans((ChannelDefine)channelDefine);
            if (null == channelService) {
                failedChannelId.add(channelDefine.getChannelId());
            }
            return channelService;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.deleteFailedChannel(failedChannelId, definesIncrement, channelServices);
        List<Long> successChannelIds = this.channelStart(channelServices);
        if (CollectionUtils.isNotEmpty(successChannelIds)) {
            this.channelServiceList.addAll(channelServices.stream().filter(channelService -> successChannelIds.contains(((AbstractChannelService)channelService).getChannelDefine().getChannelId())).collect(Collectors.toList()));
            this.channelDefineList.addAll(definesIncrement.stream().filter(channelDefine -> successChannelIds.contains(channelDefine.getChannelId())).collect(Collectors.toList()));
        }
        log.info("[add config] after current channelDefineList:{},channelServiceList:{}", (Object)this.gson.toJson(this.channelDefineList), (Object)this.gson.toJson((Object)this.gson.toJson(this.channelServiceList.stream().map(ChannelService::instanceId).collect(Collectors.toList()))));
    }

    private boolean filterCollStart(String appName) {
        String serviceName = System.getenv("K8S_SERVICE");
        if (StringUtils.isNotEmpty((CharSequence)serviceName) && StringUtils.isNotEmpty((CharSequence)appName)) {
            return serviceName.contains(appName);
        }
        return true;
    }

    private void sendCollectionProgress(List<ChannelState> channelStateList) {
        if (CollectionUtils.isEmpty(channelStateList)) {
            return;
        }
        UpdateLogProcessCmd processCmd = this.assembleLogProcessData(channelStateList);
        RpcClient rpcClient = (RpcClient)Ioc.ins().getBean(RpcClient.class);
        RemotingCommand req = RemotingCommand.createRequestCommand((int)13579);
        req.setBody(Constant.GSON.toJson((Object)processCmd).getBytes());
        rpcClient.sendToAllMessage(req);
        log.debug("send collect progress,data:{}", (Object)this.gson.toJson((Object)processCmd));
    }

    private UpdateLogProcessCmd assembleLogProcessData(List<ChannelState> channelStateList) {
        UpdateLogProcessCmd cmd = new UpdateLogProcessCmd();
        try {
            List<Object> collects;
            cmd.setIp(NetUtil.getLocalIp());
            ArrayList finalCollects = collects = Lists.newArrayList();
            channelStateList.forEach(channelState -> {
                UpdateLogProcessCmd.CollectDetail collectDetail = new UpdateLogProcessCmd.CollectDetail();
                collectDetail.setTailId(channelState.getTailId().toString());
                collectDetail.setAppId(channelState.getAppId());
                collectDetail.setTailName(channelState.getTailName());
                collectDetail.setAppName(channelState.getAppName());
                collectDetail.setIpList(channelState.getIpList());
                collectDetail.setPath(channelState.getLogPattern());
                List progressDetails = channelState.getStateProgressMap().entrySet().stream().map(entry -> UpdateLogProcessCmd.FileProgressDetail.builder().fileRowNumber(((ChannelState.StateProgress)entry.getValue()).getCurrentRowNum()).collectTime(((ChannelState.StateProgress)entry.getValue()).getCtTime()).pointer(((ChannelState.StateProgress)entry.getValue()).getPointer()).fileMaxPointer(((ChannelState.StateProgress)entry.getValue()).getFileMaxPointer()).collectPercentage(this.getPercent(((ChannelState.StateProgress)entry.getValue()).getPointer(), ((ChannelState.StateProgress)entry.getValue()).getFileMaxPointer())).configIp(((ChannelState.StateProgress)entry.getValue()).getIp()).pattern((String)entry.getKey()).build()).collect(Collectors.toList());
                collectDetail.setFileProgressDetails(progressDetails);
                finalCollects.add(collectDetail);
            });
            collects = collects.stream().distinct().collect(Collectors.toList());
            cmd.setCollectList((List)collects);
            return cmd;
        }
        catch (Exception e) {
            log.error("send collect data progress wrap data error", (Throwable)e);
            return cmd;
        }
    }

    private String getPercent(Long pointer, Long maxPointer) {
        if (null == pointer || pointer == 0L || null == maxPointer || maxPointer == 0L) {
            return "0%";
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format((float)pointer.longValue() / (float)maxPointer.longValue() * 100.0f) + "%";
    }

    public boolean isInitComplete() {
        return this.initComplete;
    }
}

