/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.parse;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ozhera.log.parse.AbstractLogParser;
import org.apache.ozhera.log.parse.LogParserData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawLogParser
extends AbstractLogParser {
    private static final Logger log = LoggerFactory.getLogger(RawLogParser.class);

    public RawLogParser(LogParserData parserData) {
        super(parserData);
    }

    @Override
    public Map<String, Object> doParse(String logData, String ip, Long lineNum, Long collectStamp, String fileName) {
        Map<String, Object> ret = this.doParseSimple(logData, collectStamp);
        this.checkMessageExist(ret, logData);
        return ret;
    }

    @Override
    public Map<String, Object> doParseSimple(String logData, Long collectStamp) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("message", logData);
        if (null != collectStamp) {
            ret.put("timestamp", collectStamp);
        }
        return ret;
    }

    @Override
    public List<String> parseLogData(String logData) {
        return Lists.newArrayList((Object[])new String[]{logData});
    }
}

