/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.manager.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
public class DataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DataSourceConfig.class);
    @NacosValue(value="${spring.datasource.driverClassName}")
    private String driverClass;
    @Value(value="${spring.datasource.default.initialPoolSize}")
    private Integer defaultInitialPoolSize;
    @Value(value="${spring.datasource.default.maxPoolSize}")
    private Integer defaultMaxPoolSize;
    @Value(value="${spring.datasource.default.minialPoolSize}")
    private Integer defaultMinPoolSize;
    @NacosValue(value="${spring.datasource.username}")
    private String dataSourceUserName;
    @NacosValue(value="${spring.datasource.url}")
    private String dataSourceUrl;
    @NacosValue(value="${spring.datasource.password}")
    private String dataSourcePasswd;
    @Value(value="${server.type}")
    private String serverType;

    @Bean(name={"masterDataSource"})
    @Primary
    public DataSource masterDataSource() throws PropertyVetoException, NamingException {
        log.info("DataSourceConfig {} {} {} {}", new Object[]{this.serverType, this.dataSourceUrl, this.dataSourceUserName});
        log.info("DataSourceConfig {} {} {} {}", new Object[]{this.serverType, this.dataSourceUrl, this.dataSourceUserName});
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setDriverClass(this.driverClass);
        dataSource.setJdbcUrl(this.dataSourceUrl);
        dataSource.setUser(this.dataSourceUserName);
        dataSource.setPassword(this.dataSourcePasswd);
        dataSource.setInitialPoolSize(this.defaultInitialPoolSize.intValue());
        dataSource.setMaxPoolSize(this.defaultMaxPoolSize.intValue());
        dataSource.setMinPoolSize(this.defaultMinPoolSize.intValue());
        this.setDatasource(dataSource);
        return dataSource;
    }

    private void setDatasource(ComboPooledDataSource dataSource) {
        dataSource.setTestConnectionOnCheckin(true);
        dataSource.setTestConnectionOnCheckout(false);
        dataSource.setPreferredTestQuery("select 1");
        dataSource.setIdleConnectionTestPeriod(180);
    }

    @Bean(name={"masterTransactionManager"})
    @Primary
    public DataSourceTransactionManager masterTransactionManager() throws PropertyVetoException, NamingException {
        return new DataSourceTransactionManager(this.masterDataSource());
    }
}

