/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Pattern;
import org.nutz.resource.NutResource;
import org.nutz.resource.impl.ResourceLocation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class SpringResourceLoaction
extends ResourceLocation
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;

    public String id() {
        return "spring";
    }

    public void scan(String base, Pattern pattern, List<NutResource> list) {
        base = pattern.matcher(base).find() ? "classpath*:" + base : "classpath*:" + base + "/**";
        try {
            Resource[] tmp;
            for (Resource resource : tmp = this.applicationContext.getResources(base)) {
                if (resource.getFilename() == null || pattern != null && !pattern.matcher(resource.getFilename()).find()) continue;
                SpringResource sr = new SpringResource();
                sr.resource = resource;
                sr.setName(resource.getFilename());
                sr.setSource("spring");
                list.add(sr);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public class SpringResource
    extends NutResource {
        protected Resource resource;

        public InputStream getInputStream() throws IOException {
            return this.resource.getInputStream();
        }
    }
}

