/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.project.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupModel;
import org.apache.ozhera.app.api.model.project.group.ProjectGroupTreeNode;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.app.dao.HeraProjectGroupDao;
import org.apache.ozhera.app.enums.CommonError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TreeQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(TreeQueryBuilder.class);
    @Autowired
    HeraProjectGroupDao projectGroupDao;
    private Set<HeraProjectGroupModel> data;
    private Map<Integer, List<HeraProjectGroupModel>> groupByParentId;

    public TreeQueryBuilder(Set<HeraProjectGroupModel> data) {
        this.data = data;
        this.groupByParentId = new HashMap<Integer, List<HeraProjectGroupModel>>();
        this.groupDataByParentId();
    }

    private void groupDataByParentId() {
        for (HeraProjectGroupModel group : this.data) {
            int parentId = group.getParentGroupId();
            this.groupByParentId.computeIfAbsent(parentId, k -> new ArrayList()).add(group);
        }
    }

    private List<ProjectGroupTreeNode> buildTreeChildren(Integer parentId) {
        ArrayList<ProjectGroupTreeNode> result = new ArrayList<ProjectGroupTreeNode>();
        List groups = this.groupByParentId.getOrDefault(parentId, new ArrayList());
        for (HeraProjectGroupModel group : groups) {
            ProjectGroupTreeNode node = new ProjectGroupTreeNode(group.getId(), group.getType(), group.getLevel(), group.getRelationObjectId(), group.getName(), group.getCnName(), group.getParentGroupId());
            List<ProjectGroupTreeNode> children = this.buildTreeChildren(group.getId());
            node.setChildren(children);
            result.add(node);
        }
        return result;
    }

    public Result<ProjectGroupTreeNode> getTreeByProjectGroup(HeraProjectGroupModel projectGroup) {
        if (projectGroup == null || projectGroup.getId() == null) {
            log.error("getTreeByProjectGroup error! param is invalid!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        ProjectGroupTreeNode treeNode = new ProjectGroupTreeNode(projectGroup);
        List<ProjectGroupTreeNode> projectGroupTreeNodes = this.buildTreeChildren(treeNode.getId());
        treeNode.setChildren(projectGroupTreeNodes);
        return Result.success((Object)treeNode);
    }
}

