/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ozhera.log.manager.model.dto.LogDataDTO;

public class ExportUtils {
    public static Map<String, Object> SplitTooLongContent(LogDataDTO logDataDto) {
        int maxCellLen = Short.MAX_VALUE;
        Map<String, Object> logOfKV = logDataDto.getLogOfKV();
        LinkedHashMap<String, Object> newLogOfKV = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : logOfKV.entrySet()) {
            String keyStr = entry.getKey();
            String valueStr = entry.getValue() == null ? "" : entry.getValue().toString();
            int entryLen = valueStr.length();
            if (entryLen > maxCellLen) {
                int cnt = entryLen / maxCellLen;
                if (entryLen % maxCellLen != 0) {
                    ++cnt;
                }
                for (int i = 0; i < cnt; ++i) {
                    String entryKey = String.format("%s-%d", keyStr, i);
                    String entryValue = "";
                    int end = (i + 1) * maxCellLen;
                    if (end > entryLen) {
                        end = entryLen;
                    }
                    entryValue = valueStr.substring(i * maxCellLen, end);
                    newLogOfKV.put(entryKey, entryValue);
                }
                continue;
            }
            newLogOfKV.put(keyStr, entry.getValue());
        }
        return newLogOfKV;
    }
}

