/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.nacos.impl;

import com.alibaba.nacos.api.config.ConfigService;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.nacos.DynamicConfigProvider;
import org.apache.ozhera.log.model.MiLogStreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConfigNacosProvider
implements DynamicConfigProvider<MiLogStreamConfig> {
    private static final Logger log = LoggerFactory.getLogger(StreamConfigNacosProvider.class);
    private ConfigService configService;

    @Override
    public MiLogStreamConfig getConfig(Long spaceId) {
        try {
            String rules = null == spaceId ? this.configService.getConfig(CommonExtensionServiceFactory.getCommonExtensionService().getLogManagePrefix() + "create_namespace_config", "DEFAULT_GROUP", Constant.DEFAULT_TIME_OUT_MS.longValue()) : this.configService.getConfig(CommonExtensionServiceFactory.getCommonExtensionService().getSpaceDataId(spaceId), "DEFAULT_GROUP", Constant.DEFAULT_TIME_OUT_MS.longValue());
            log.info("The NACOS query log is initially configured\uff1a{}", (Object)rules);
            if (StringUtils.isNotEmpty((CharSequence)rules)) {
                return (MiLogStreamConfig)gson.fromJson(rules, MiLogStreamConfig.class);
            }
        }
        catch (Exception e) {
            log.error("Query namespace configuration data data exceptions", (Throwable)e);
        }
        return null;
    }

    public MiLogStreamConfig getConfig(String appName, String dataId) {
        String rules = null;
        try {
            rules = this.configService.getConfig(dataId, "DEFAULT_GROUP", Constant.DEFAULT_TIME_OUT_MS.longValue());
            if (StringUtils.isNotEmpty((CharSequence)rules)) {
                return (MiLogStreamConfig)gson.fromJson(rules, MiLogStreamConfig.class);
            }
        }
        catch (Exception e) {
            log.error(String.format("Query namespace configuration data data exceptions, parameters:%s", dataId), (Throwable)e);
        }
        return null;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }
}

