/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntitiesActiveKey;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.exceptions.AlreadyExistsException;
import org.apache.polaris.core.persistence.BaseMetaStoreManager;
import org.apache.polaris.core.persistence.PrincipalSecretsGenerator;
import org.apache.polaris.core.persistence.RetryOnConcurrencyException;
import org.apache.polaris.core.persistence.pagination.EntityIdToken;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.transactional.AbstractTransactionalPersistence;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.extension.persistence.impl.eclipselink.PolarisEclipseLinkPersistenceUnit;
import org.apache.polaris.extension.persistence.impl.eclipselink.PolarisEclipseLinkStore;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntity;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntityActive;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntityChangeTracking;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelGrantRecord;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelPolicyMappingRecord;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelPrincipalSecrets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisEclipseLinkMetaStoreSessionImpl
extends AbstractTransactionalPersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisEclipseLinkMetaStoreSessionImpl.class);
    private static final ConcurrentHashMap<String, EntityManagerFactory> realmFactories = new ConcurrentHashMap();
    private final EntityManagerFactory emf;
    private final ThreadLocal<EntityManager> localSession = new ThreadLocal();
    private final PolarisEclipseLinkStore store;
    private final PolarisStorageIntegrationProvider storageIntegrationProvider;
    private final PrincipalSecretsGenerator secretsGenerator;

    public PolarisEclipseLinkMetaStoreSessionImpl(@Nonnull PolarisDiagnostics diagnostics, @Nonnull PolarisEclipseLinkStore store, @Nonnull PolarisStorageIntegrationProvider storageIntegrationProvider, @Nonnull RealmContext realmContext, @Nullable String confFile, @Nullable String persistenceUnitName, @Nonnull PrincipalSecretsGenerator secretsGenerator) {
        super(diagnostics);
        LOGGER.debug("Creating EclipseLink Meta Store Session for realm {}", (Object)realmContext.getRealmIdentifier());
        this.emf = this.createEntityManagerFactory(realmContext, confFile, persistenceUnitName);
        this.store = store;
        try (EntityManager session = this.emf.createEntityManager();){
            this.store.initialize(session);
        }
        this.storageIntegrationProvider = storageIntegrationProvider;
        this.secretsGenerator = secretsGenerator;
    }

    private EntityManagerFactory createEntityManagerFactory(@Nonnull RealmContext realmContext, @Nullable String confFile, @Nullable String persistenceUnitName) {
        String realm = realmContext.getRealmIdentifier();
        return realmFactories.computeIfAbsent(realm, key -> {
            try {
                PolarisEclipseLinkPersistenceUnit persistenceUnit = PolarisEclipseLinkPersistenceUnit.locatePersistenceUnit(confFile, persistenceUnitName);
                return persistenceUnit.createEntityManagerFactory(realmContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @VisibleForTesting
    static void clearEntityManagerFactories() {
        realmFactories.clear();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public <T> T runInTransaction(@Nonnull PolarisCallContext callCtx, @Nonnull Supplier<T> transactionCode) {
        this.getDiagnostics().check(this.localSession.get() == null, "cannot nest transaction");
        try (EntityManager session = this.emf.createEntityManager();){
            T t;
            this.localSession.set(session);
            EntityTransaction tr = session.getTransaction();
            try {
                tr.begin();
                T result = transactionCode.get();
                if (session.getTransaction().isActive()) {
                    tr.commit();
                    LOGGER.debug("transaction committed");
                }
                t = result;
            }
            catch (Exception e) {
                if (tr.isActive()) {
                    tr.rollback();
                }
                LOGGER.debug("transaction rolled back", (Throwable)e);
                if (e instanceof OptimisticLockException || e.getCause() instanceof OptimisticLockException) {
                    throw new RetryOnConcurrencyException((Throwable)e);
                }
                throw e;
            }
            finally {
                this.localSession.remove();
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (PersistenceException e) {
            if (e.toString().toLowerCase(Locale.ROOT).contains("duplicate key")) {
                throw new AlreadyExistsException("Duplicate key error when persisting entity", (Throwable)e);
            }
            throw new RuntimeException("Error persisting entity", e);
        }
    }

    public void runActionInTransaction(@Nonnull PolarisCallContext callCtx, @Nonnull Runnable transactionCode) {
        this.getDiagnostics().check(this.localSession.get() == null, "cannot nest transaction");
        try (EntityManager session = this.emf.createEntityManager();){
            this.localSession.set(session);
            EntityTransaction tr = session.getTransaction();
            try {
                tr.begin();
                transactionCode.run();
                if (session.getTransaction().isActive()) {
                    tr.commit();
                    LOGGER.debug("transaction committed");
                }
            }
            catch (Exception e) {
                LOGGER.debug("Rolling back transaction due to an error", (Throwable)e);
                if (tr.isActive()) {
                    tr.rollback();
                }
                if (e instanceof OptimisticLockException || e.getCause() instanceof OptimisticLockException) {
                    throw new RetryOnConcurrencyException((Throwable)e);
                }
                throw e;
            }
            finally {
                this.localSession.remove();
            }
        }
    }

    public <T> T runInReadTransaction(@Nonnull PolarisCallContext callCtx, @Nonnull Supplier<T> transactionCode) {
        return this.runInTransaction(callCtx, transactionCode);
    }

    public void runActionInReadTransaction(@Nonnull PolarisCallContext callCtx, @Nonnull Runnable transactionCode) {
        this.runActionInTransaction(callCtx, transactionCode);
    }

    public long generateNewIdInCurrentTxn(@Nonnull PolarisCallContext callCtx) {
        return this.localSession.get() != null ? this.store.getNextSequence(this.localSession.get()) : this.runInReadTransaction(callCtx, () -> this.generateNewIdInCurrentTxn(callCtx)).longValue();
    }

    public void writeToEntitiesInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        this.store.writeToEntities(this.localSession.get(), entity);
    }

    public <T extends PolarisStorageConfigurationInfo> void persistStorageIntegrationIfNeededInCurrentTxn(@Nonnull PolarisCallContext callContext, @Nonnull PolarisBaseEntity entity, @Nullable PolarisStorageIntegration<T> storageIntegration) {
    }

    public void writeToEntitiesActiveInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        this.store.writeToEntitiesActive(this.localSession.get(), entity);
    }

    public void writeToEntitiesChangeTrackingInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        this.store.writeToEntitiesChangeTracking(this.localSession.get(), entity);
    }

    public void writeToGrantRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisGrantRecord grantRec) {
        this.store.writeToGrantRecords(this.localSession.get(), grantRec);
    }

    public void deleteFromEntitiesInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity) {
        this.store.deleteFromEntities(this.localSession.get(), entity.getCatalogId(), entity.getId(), entity.getTypeCode());
    }

    public void deleteFromEntitiesActiveInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity) {
        this.store.deleteFromEntitiesActive(this.localSession.get(), new PolarisEntitiesActiveKey(entity));
    }

    public void deleteFromEntitiesChangeTrackingInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity) {
        this.store.deleteFromEntitiesChangeTracking(this.localSession.get(), entity);
    }

    public void deleteFromGrantRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisGrantRecord grantRec) {
        this.store.deleteFromGrantRecords(this.localSession.get(), grantRec);
    }

    public void deleteAllEntityGrantRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity, @Nonnull List<PolarisGrantRecord> grantsOnGrantee, @Nonnull List<PolarisGrantRecord> grantsOnSecurable) {
        this.store.deleteAllEntityGrantRecords(this.localSession.get(), entity);
    }

    public void deleteAllInCurrentTxn(@Nonnull PolarisCallContext callCtx) {
        this.store.deleteAll(this.localSession.get());
    }

    @Nullable
    public PolarisBaseEntity lookupEntityInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, int typeCode) {
        return ModelEntity.toEntity(this.store.lookupEntity(this.localSession.get(), catalogId, entityId, typeCode));
    }

    @Nonnull
    public List<PolarisBaseEntity> lookupEntitiesInCurrentTxn(@Nonnull PolarisCallContext callCtx, List<PolarisEntityId> entityIds) {
        return this.store.lookupEntities(this.localSession.get(), entityIds).stream().map(ModelEntity::toEntity).toList();
    }

    @Nonnull
    public List<PolarisChangeTrackingVersions> lookupEntityVersionsInCurrentTxn(@Nonnull PolarisCallContext callCtx, List<PolarisEntityId> entityIds) {
        Map<PolarisEntityId, ModelEntity> idToEntityMap = this.store.lookupEntities(this.localSession.get(), entityIds).stream().collect(Collectors.toMap(entry -> new PolarisEntityId(entry.getCatalogId(), entry.getId()), entry -> entry));
        return entityIds.stream().map(entityId -> {
            ModelEntity entity = idToEntityMap.getOrDefault(entityId, null);
            return entity == null ? null : new PolarisChangeTrackingVersions(entity.getEntityVersion(), entity.getGrantRecordsVersion());
        }).collect(Collectors.toList());
    }

    @Nullable
    public EntityNameLookupRecord lookupEntityActiveInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntitiesActiveKey entityActiveKey) {
        return ModelEntityActive.toEntityActive(this.store.lookupEntityActive(this.localSession.get(), entityActiveKey));
    }

    @Nonnull
    public List<EntityNameLookupRecord> lookupEntityActiveBatchInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntitiesActiveKey> entityActiveKeys) {
        return entityActiveKeys.stream().map(entityActiveKey -> this.lookupEntityActiveInCurrentTxn(callCtx, (PolarisEntitiesActiveKey)entityActiveKey)).collect(Collectors.toList());
    }

    @Nonnull
    public <T> Page<T> loadEntitiesInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull Predicate<PolarisBaseEntity> entityFilter, @Nonnull Function<PolarisBaseEntity, T> transformer, @Nonnull PageToken pageToken) {
        Stream<PolarisBaseEntity> data = this.store.lookupFullEntitiesActive(this.localSession.get(), catalogId, parentId, entityType, entitySubType, pageToken).stream().map(ModelEntity::toEntity).filter(entityFilter);
        return Page.mapped((PageToken)pageToken, data, transformer, EntityIdToken::fromEntity);
    }

    public boolean hasChildrenInCurrentTxn(@Nonnull PolarisCallContext callContext, @Nullable PolarisEntityType entityType, long catalogId, long parentId) {
        return this.store.countActiveChildEntities(this.localSession.get(), catalogId, parentId, entityType) > 0L;
    }

    public int lookupEntityGrantRecordsVersionInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId) {
        ModelEntityChangeTracking entity = this.store.lookupEntityChangeTracking(this.localSession.get(), catalogId, entityId);
        return entity == null ? 0 : entity.getGrantRecordsVersion();
    }

    @Nullable
    public PolarisGrantRecord lookupGrantRecordInCurrentTxn(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId, long granteeCatalogId, long granteeId, int privilegeCode) {
        return ModelGrantRecord.toGrantRecord(this.store.lookupGrantRecord(this.localSession.get(), securableCatalogId, securableId, granteeCatalogId, granteeId, privilegeCode));
    }

    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnSecurableInCurrentTxn(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId) {
        return this.store.lookupAllGrantRecordsOnSecurable(this.localSession.get(), securableCatalogId, securableId).stream().map(ModelGrantRecord::toGrantRecord).toList();
    }

    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnGranteeInCurrentTxn(@Nonnull PolarisCallContext callCtx, long granteeCatalogId, long granteeId) {
        return this.store.lookupGrantRecordsOnGrantee(this.localSession.get(), granteeCatalogId, granteeId).stream().map(ModelGrantRecord::toGrantRecord).toList();
    }

    @Nullable
    public PolarisPrincipalSecrets loadPrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId) {
        return ModelPrincipalSecrets.toPrincipalSecrets(this.store.lookupPrincipalSecrets(this.localSession.get(), clientId));
    }

    @Nonnull
    public PolarisPrincipalSecrets generateNewPrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull String principalName, long principalId) {
        PolarisPrincipalSecrets principalSecrets;
        ModelPrincipalSecrets lookupPrincipalSecrets;
        do {
            principalSecrets = this.secretsGenerator.produceSecrets(principalName, principalId);
        } while ((lookupPrincipalSecrets = this.store.lookupPrincipalSecrets(this.localSession.get(), principalSecrets.getPrincipalClientId())) != null);
        this.store.writePrincipalSecrets(this.localSession.get(), principalSecrets);
        return principalSecrets;
    }

    @Nonnull
    public PolarisPrincipalSecrets rotatePrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        PolarisPrincipalSecrets principalSecrets = ModelPrincipalSecrets.toPrincipalSecrets(this.store.lookupPrincipalSecrets(this.localSession.get(), clientId));
        this.getDiagnostics().checkNotNull((Object)principalSecrets, "cannot_find_secrets", "client_id={} principalId={}", new Object[]{clientId, principalId});
        this.getDiagnostics().check(principalId == principalSecrets.getPrincipalId(), "principal_id_mismatch", "expectedId={} id={}", new Object[]{principalId, principalSecrets.getPrincipalId()});
        principalSecrets.rotateSecrets(oldSecretHash);
        if (reset) {
            principalSecrets.rotateSecrets(principalSecrets.getMainSecretHash());
        }
        this.store.writePrincipalSecrets(this.localSession.get(), principalSecrets);
        return principalSecrets;
    }

    public void deletePrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId) {
        ModelPrincipalSecrets principalSecrets = this.store.lookupPrincipalSecrets(this.localSession.get(), clientId);
        this.getDiagnostics().checkNotNull((Object)principalSecrets, "cannot_find_secrets", "client_id={} principalId={}", new Object[]{clientId, principalId});
        this.getDiagnostics().check(principalId == principalSecrets.getPrincipalId(), "principal_id_mismatch", "expectedId={} id={}", new Object[]{principalId, principalSecrets.getPrincipalId()});
        this.store.deletePrincipalSecrets(this.localSession.get(), clientId);
    }

    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> createStorageIntegrationInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, PolarisStorageConfigurationInfo polarisStorageConfigurationInfo) {
        return this.storageIntegrationProvider.getStorageIntegrationForConfig(polarisStorageConfigurationInfo);
    }

    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> loadPolarisStorageIntegrationInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        PolarisStorageConfigurationInfo storageConfig = BaseMetaStoreManager.extractStorageConfiguration((PolarisDiagnostics)this.getDiagnostics(), (PolarisBaseEntity)entity);
        return this.storageIntegrationProvider.getStorageIntegrationForConfig(storageConfig);
    }

    public void writeToPolicyMappingRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record) {
        this.store.writeToPolicyMappingRecords(this.localSession.get(), record);
    }

    public void deleteFromPolicyMappingRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record) {
        this.store.deleteFromPolicyMappingRecords(this.localSession.get(), record);
    }

    public void deleteAllEntityPolicyMappingRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, @Nonnull List<PolarisPolicyMappingRecord> mappingOnTarget, @Nonnull List<PolarisPolicyMappingRecord> mappingOnPolicy) {
        this.store.deleteAllEntityPolicyMappingRecords(this.localSession.get(), entity);
    }

    @Nullable
    public PolarisPolicyMappingRecord lookupPolicyMappingRecordInCurrentTxn(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId, int policyTypeCode, long policyCatalogId, long policyId) {
        return ModelPolicyMappingRecord.toPolicyMappingRecord(this.store.lookupPolicyMappingRecord(this.localSession.get(), targetCatalogId, targetId, policyTypeCode, policyCatalogId, policyId));
    }

    @Nonnull
    public List<PolarisPolicyMappingRecord> loadPoliciesOnTargetByTypeInCurrentTxn(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId, int policyTypeCode) {
        return this.store.loadPoliciesOnTargetByType(this.localSession.get(), targetCatalogId, targetId, policyTypeCode).stream().map(ModelPolicyMappingRecord::toPolicyMappingRecord).toList();
    }

    @Nonnull
    public List<PolarisPolicyMappingRecord> loadAllPoliciesOnTargetInCurrentTxn(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId) {
        return this.store.loadAllPoliciesOnTarget(this.localSession.get(), targetCatalogId, targetId).stream().map(ModelPolicyMappingRecord::toPolicyMappingRecord).toList();
    }

    @Nonnull
    public List<PolarisPolicyMappingRecord> loadAllTargetsOnPolicyInCurrentTxn(@Nonnull PolarisCallContext callCtx, long policyCatalogId, long policyId, int policyTypeCode) {
        return this.store.loadAllTargetsOnPolicy(this.localSession.get(), policyCatalogId, policyId, policyTypeCode).stream().map(ModelPolicyMappingRecord::toPolicyMappingRecord).toList();
    }

    public void rollback() {
        EntityManager session = this.localSession.get();
        if (session != null) {
            session.getTransaction().rollback();
        }
    }

    public <T extends PolarisEntity> Optional<Optional<String>> hasOverlappingSiblings(@Nonnull PolarisCallContext callContext, T entity) {
        return Optional.empty();
    }
}

