/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import com.google.common.base.Preconditions;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.service.auth.AuthenticationConfiguration;
import org.apache.polaris.service.auth.AuthenticationRealmConfiguration;
import org.apache.polaris.service.auth.JWTSymmetricKeyBroker;
import org.apache.polaris.service.auth.TokenBroker;
import org.apache.polaris.service.auth.TokenBrokerFactory;

@ApplicationScoped
@Identifier(value="symmetric-key")
public class JWTSymmetricKeyFactory
implements TokenBrokerFactory {
    private final MetaStoreManagerFactory metaStoreManagerFactory;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final ConcurrentMap<String, JWTSymmetricKeyBroker> tokenBrokers = new ConcurrentHashMap<String, JWTSymmetricKeyBroker>();

    @Inject
    public JWTSymmetricKeyFactory(MetaStoreManagerFactory metaStoreManagerFactory, AuthenticationConfiguration authenticationConfiguration) {
        this.metaStoreManagerFactory = metaStoreManagerFactory;
        this.authenticationConfiguration = authenticationConfiguration;
    }

    @Override
    public TokenBroker apply(RealmContext realmContext) {
        return this.tokenBrokers.computeIfAbsent(realmContext.getRealmIdentifier(), k -> this.createTokenBroker(realmContext));
    }

    private JWTSymmetricKeyBroker createTokenBroker(RealmContext realmContext) {
        AuthenticationRealmConfiguration config = this.authenticationConfiguration.forRealm(realmContext);
        Duration maxTokenGeneration = config.tokenBroker().maxTokenGeneration();
        AuthenticationRealmConfiguration.TokenBrokerConfiguration.SymmetricKeyConfiguration symmetricKeyConfiguration = config.tokenBroker().symmetricKey().orElseThrow(() -> new IllegalStateException("Symmetric key configuration is missing"));
        String secret = symmetricKeyConfiguration.secret().orElse(null);
        Path file = symmetricKeyConfiguration.file().orElse(null);
        Preconditions.checkState((secret != null || file != null ? 1 : 0) != 0, (Object)"Either file or secret must be set");
        Supplier<String> secretSupplier = secret != null ? () -> secret : JWTSymmetricKeyFactory.readSecretFromDisk(file);
        return new JWTSymmetricKeyBroker(this.metaStoreManagerFactory.getOrCreateMetaStoreManager(realmContext), (int)maxTokenGeneration.toSeconds(), secretSupplier);
    }

    private static Supplier<String> readSecretFromDisk(Path file) {
        return () -> {
            try {
                return Files.readString(file);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read secret from file: " + String.valueOf(file), e);
            }
        };
    }
}

