/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.events;

import com.google.common.collect.Streams;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.List;
import org.apache.polaris.service.events.AfterTableCommitedEvent;
import org.apache.polaris.service.events.AfterTableRefreshedEvent;
import org.apache.polaris.service.events.AfterTaskAttemptedEvent;
import org.apache.polaris.service.events.AfterViewCommitedEvent;
import org.apache.polaris.service.events.AfterViewRefreshedEvent;
import org.apache.polaris.service.events.BeforeRequestRateLimitedEvent;
import org.apache.polaris.service.events.BeforeTableCommitedEvent;
import org.apache.polaris.service.events.BeforeTableRefreshedEvent;
import org.apache.polaris.service.events.BeforeTaskAttemptedEvent;
import org.apache.polaris.service.events.BeforeViewCommitedEvent;
import org.apache.polaris.service.events.BeforeViewRefreshedEvent;
import org.apache.polaris.service.events.PolarisEvent;
import org.apache.polaris.service.events.PolarisEventListener;

@ApplicationScoped
@Identifier(value="test")
public class TestPolarisEventListener
extends PolarisEventListener {
    private final List<PolarisEvent> history = new ArrayList<PolarisEvent>();

    public <T> T getLatest(Class<T> type) {
        return (T)Streams.findLast(this.history.stream().filter(type::isInstance)).map(type::cast).orElseThrow();
    }

    @Override
    public void onBeforeRequestRateLimited(BeforeRequestRateLimitedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onBeforeTableCommited(BeforeTableCommitedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onAfterTableCommited(AfterTableCommitedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onBeforeViewCommited(BeforeViewCommitedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onAfterViewCommited(AfterViewCommitedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onBeforeTableRefreshed(BeforeTableRefreshedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onAfterTableRefreshed(AfterTableRefreshedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onBeforeViewRefreshed(BeforeViewRefreshedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onAfterViewRefreshed(AfterViewRefreshedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onBeforeTaskAttempted(BeforeTaskAttemptedEvent event) {
        this.history.add(event);
    }

    @Override
    public void onAfterTaskAttempted(AfterTaskAttemptedEvent event) {
        this.history.add(event);
    }
}

