/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import jakarta.annotation.Nonnull;
import java.util.Map;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.GenerateEntityIdResult;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;

public abstract class BaseMetaStoreManager
implements PolarisMetaStoreManager {
    private final PolarisDiagnostics diagnostics;

    public static PolarisStorageConfigurationInfo extractStorageConfiguration(@Nonnull PolarisDiagnostics diagnostics, PolarisBaseEntity reloadedEntity) {
        Map<String, String> propMap = reloadedEntity.getInternalPropertiesAsMap();
        String storageConfigInfoStr = propMap.get(PolarisEntityConstants.getStorageConfigInfoPropertyName());
        diagnostics.check(storageConfigInfoStr != null, "missing_storage_configuration_info", "catalogId={}, entityId={}", reloadedEntity.getCatalogId(), reloadedEntity.getId());
        return PolarisStorageConfigurationInfo.deserialize(storageConfigInfoStr);
    }

    protected BaseMetaStoreManager(PolarisDiagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }

    protected PolarisDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    protected PolarisBaseEntity prepareToPersistNewEntity(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisBaseEntity entity) {
        this.getDiagnostics().checkNotNull(entity, "unexpected_null_entity");
        this.getDiagnostics().checkNotNull(entity.getName(), "unexpected_null_name", "entity={}", entity);
        PolarisEntityType type = PolarisEntityType.fromCode(entity.getTypeCode());
        this.getDiagnostics().checkNotNull(type, "unknown_type", "entity={}", entity);
        PolarisEntitySubType subType = PolarisEntitySubType.fromCode(entity.getSubTypeCode());
        this.getDiagnostics().checkNotNull(subType, "unexpected_null_subType", "entity={}", entity);
        this.getDiagnostics().check(subType.getParentType() == null || subType.getParentType() == type, "invalid_subtype", "type={} subType={}", new Object[]{type, subType});
        this.getDiagnostics().check(!type.isTopLevel() || entity.getParentId() == PolarisEntityConstants.getRootEntityId(), "top_level_parent_should_be_account", "entity={}", entity);
        this.getDiagnostics().check(entity.getId() != 0L || type == PolarisEntityType.ROOT, "id_not_set", "entity={}", entity);
        this.getDiagnostics().check(entity.getCreateTimestamp() != 0L, "null_create_timestamp");
        PolarisBaseEntity.Builder entityBuilder = new PolarisBaseEntity.Builder(entity);
        entityBuilder.lastUpdateTimestamp(entity.getCreateTimestamp());
        entityBuilder.dropTimestamp(0L);
        entityBuilder.purgeTimestamp(0L);
        entityBuilder.toPurgeTimestamp(0L);
        return entityBuilder.build();
    }

    @Nonnull
    protected PolarisBaseEntity prepareToPersistEntityAfterChange(@Nonnull PolarisCallContext callCtx, @Nonnull BasePersistence ms, @Nonnull PolarisBaseEntity entity, boolean nameOrParentChanged, @Nonnull PolarisBaseEntity originalEntity) {
        this.getDiagnostics().checkNotNull(entity, "unexpected_null_entity");
        this.getDiagnostics().checkNotNull(entity.getName(), "unexpected_null_name", "entity={}", entity);
        PolarisEntityType type = entity.getType();
        this.getDiagnostics().checkNotNull(type, "unexpected_null_type", "entity={}", entity);
        PolarisEntitySubType subType = entity.getSubType();
        this.getDiagnostics().checkNotNull(subType, "unexpected_null_subType", "entity={}", entity);
        this.getDiagnostics().check(subType.getParentType() == null || subType.getParentType() == type, "invalid_subtype", "type={} subType={} entity={}", new Object[]{type, subType, entity});
        this.getDiagnostics().check(entity.getDropTimestamp() == 0L, "entity_dropped", "entity={}", entity);
        long createTimestamp = entity.getCreateTimestamp();
        this.getDiagnostics().check(createTimestamp != 0L, "null_create_timestamp", "entity={}", entity);
        long now = System.currentTimeMillis();
        if (now < entity.getCreateTimestamp()) {
            now = entity.getCreateTimestamp() + 1L;
        }
        PolarisBaseEntity.Builder entityBuilder = new PolarisBaseEntity.Builder(entity);
        entityBuilder.lastUpdateTimestamp(now).entityVersion(entity.getEntityVersion() + 1);
        return entityBuilder.build();
    }

    @Override
    @Nonnull
    public GenerateEntityIdResult generateNewEntityId(@Nonnull PolarisCallContext callCtx) {
        BasePersistence ms = callCtx.getMetaStore();
        return new GenerateEntityIdResult(ms.generateNewId(callCtx));
    }
}

