/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.remote.RemoteStat;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RemoteBucketState
implements ComparableByContent<RemoteBucketState> {
    private BucketState state;
    private RemoteStat stat;
    private Long configurationVersion;
    public static final SerializationHandle<RemoteBucketState> SERIALIZATION_HANDLE = new SerializationHandle<RemoteBucketState>(){

        @Override
        public <S> RemoteBucketState deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            boolean hasConfigurationVersion;
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_8_1_0);
            BucketConfiguration bucketConfiguration = BucketConfiguration.SERIALIZATION_HANDLE.deserialize(adapter, input);
            BucketState bucketState = BucketState.deserialize(adapter, input);
            bucketState.setConfiguration(bucketConfiguration);
            RemoteStat stat = RemoteStat.SERIALIZATION_HANDLE.deserialize(adapter, input);
            Long configurationVersion = null;
            if (formatNumber >= Versions.v_8_1_0.getNumber() && (hasConfigurationVersion = adapter.readBoolean(input))) {
                configurationVersion = adapter.readLong(input);
            }
            return new RemoteBucketState(bucketState, stat, configurationVersion);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, RemoteBucketState remoteState, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            Versions serializationVersion;
            if (remoteState.configurationVersion == null) {
                serializationVersion = Versions.v_7_0_0;
            } else if (backwardCompatibilityVersion.getNumber() >= Versions.v_8_1_0.getNumber()) {
                serializationVersion = Versions.v_8_1_0;
            } else if (scope == Scope.RESPONSE) {
                serializationVersion = Versions.v_7_0_0;
            } else {
                throw new IllegalStateException("configurationVersion is not supported in format number " + backwardCompatibilityVersion.getNumber());
            }
            adapter.writeInt(output, serializationVersion.getNumber());
            BucketConfiguration.SERIALIZATION_HANDLE.serialize(adapter, output, remoteState.getConfiguration(), backwardCompatibilityVersion, scope);
            BucketState.serialize(adapter, output, remoteState.state, backwardCompatibilityVersion, scope);
            RemoteStat.SERIALIZATION_HANDLE.serialize(adapter, output, remoteState.stat, backwardCompatibilityVersion, scope);
            if (serializationVersion == Versions.v_8_1_0) {
                if (remoteState.configurationVersion != null) {
                    adapter.writeBoolean(output, true);
                    adapter.writeLong(output, remoteState.configurationVersion);
                } else {
                    adapter.writeBoolean(output, false);
                }
            }
        }

        @Override
        public int getTypeId() {
            return 5;
        }

        @Override
        public Class<RemoteBucketState> getSerializedType() {
            return RemoteBucketState.class;
        }

        @Override
        public RemoteBucketState fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_8_1_0);
            BucketState state = BucketState.fromJsonCompatibleSnapshot((Map)snapshot.get("state"));
            RemoteStat stat = RemoteStat.SERIALIZATION_HANDLE.fromJsonCompatibleSnapshot((Map)snapshot.get("stat"));
            Long configurationVersion = null;
            if (formatNumber >= Versions.v_8_1_0.getNumber()) {
                configurationVersion = this.readOptionalLongValue(snapshot, "configurationVersion");
            }
            return new RemoteBucketState(state, stat, configurationVersion);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(RemoteBucketState remoteState, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            Versions serializationVersion;
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (remoteState.configurationVersion == null) {
                serializationVersion = Versions.v_7_0_0;
            } else if (backwardCompatibilityVersion.getNumber() >= Versions.v_8_1_0.getNumber()) {
                serializationVersion = Versions.v_8_1_0;
            } else if (scope == Scope.RESPONSE) {
                serializationVersion = Versions.v_7_0_0;
            } else {
                throw new IllegalStateException("configurationVersion is not supported in format number " + backwardCompatibilityVersion.getNumber());
            }
            result.put("version", serializationVersion.getNumber());
            result.put("state", BucketState.toJsonCompatibleSnapshot(remoteState.state, backwardCompatibilityVersion, scope));
            result.put("stat", RemoteStat.SERIALIZATION_HANDLE.toJsonCompatibleSnapshot(remoteState.stat, backwardCompatibilityVersion, scope));
            if (serializationVersion == Versions.v_8_1_0) {
                result.put("configurationVersion", remoteState.configurationVersion);
            }
            return result;
        }

        @Override
        public String getTypeName() {
            return "RemoteBucketState";
        }
    };

    public RemoteBucketState(BucketState state, RemoteStat stat, Long configurationVersion) {
        this.state = state;
        this.stat = stat;
        this.configurationVersion = configurationVersion;
    }

    public void refillAllBandwidth(long currentTimeNanos) {
        this.state.refillAllBandwidth(currentTimeNanos);
    }

    public long getAvailableTokens() {
        return this.state.getAvailableTokens();
    }

    public void consume(long tokensToConsume) {
        this.state.consume(tokensToConsume);
        this.stat.addConsumedTokens(tokensToConsume);
    }

    public long calculateFullRefillingTime(long currentTimeNanos) {
        return this.state.calculateFullRefillingTime(currentTimeNanos);
    }

    public long calculateDelayNanosAfterWillBePossibleToConsume(long tokensToConsume, long currentTimeNanos, boolean checkTokensToConsumeShouldBeLessThenCapacity) {
        return this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, checkTokensToConsumeShouldBeLessThenCapacity);
    }

    public void addTokens(long tokensToAdd) {
        this.state.addTokens(tokensToAdd);
    }

    public void forceAddTokens(long tokensToAdd) {
        this.state.forceAddTokens(tokensToAdd);
    }

    public void reset() {
        this.state.reset();
    }

    public BucketState copyBucketState() {
        return this.state.copy();
    }

    public void replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy, long currentTimeNanos) {
        this.state = this.state.replaceConfiguration(newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
    }

    public BucketConfiguration getConfiguration() {
        return this.state.getConfiguration();
    }

    public RemoteStat getRemoteStat() {
        return this.stat;
    }

    public BucketState getState() {
        return this.state;
    }

    public Long getConfigurationVersion() {
        return this.configurationVersion;
    }

    public void setConfigurationVersion(Long configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    @Override
    public boolean equalsByContent(RemoteBucketState other) {
        return ComparableByContent.equals(this.state, other.state) && ComparableByContent.equals(this.state.getConfiguration(), other.getConfiguration()) && ComparableByContent.equals(this.stat, other.stat);
    }

    public RemoteBucketState copy() {
        return new RemoteBucketState(this.state.copy(), this.stat.copy(), this.configurationVersion);
    }

    public String toString() {
        return "RemoteBucketState{state=" + this.state + ", stat=" + this.stat + ", configurationVersion=" + this.configurationVersion + '}';
    }
}

