/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fldr;

import dm.jdbc.convert.J2DB;
import dm.jdbc.desc.Column;
import dm.jdbc.desc.Parameter;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.util.ByteUtil;

public class HashCode {
    private static final long HC_MASK = 0xFFFFFFFFL;
    private static final int TZ_INVALID_VALUE = 1000;
    private static final int TZ_DEFAULT_VALUE = 480;
    private static int[] global_days_befor_month;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        global_days_befor_month = nArray;
    }

    public static long hc_calc_fold_value(long[] lArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < lArray.length) {
            n2 += (int)lArray[n3];
            ++n3;
        }
        return (long)n2 & 0xFFFFFFFFL;
    }

    public static long hc_get_fold_fun(Parameter parameter, Object object, DmdbConnection dmdbConnection) {
        int n2 = parameter.type;
        boolean bl = dmdbConnection.caseSensitive;
        byte[] byArray = J2DB.fromObject(object, parameter, dmdbConnection);
        switch (n2) {
            case 3: 
            case 5: 
            case 6: 
            case 29: {
                return HashCode.hc_get_l4_fold(byArray);
            }
            case 7: 
            case 10: {
                return HashCode.hc_get_int_fold(byArray);
            }
            case 8: {
                return HashCode.hc_get_int64_fold(byArray);
            }
            case 14: 
            case 16: 
            case 26: {
                return HashCode.hc_get_datetime_fold(byArray);
            }
            case 23: 
            case 27: {
                int[] nArray = DmdbTimestamp.valueOf((byte[])byArray, (Column)parameter, (IDmdbConnection)dmdbConnection).dt;
                return HashCode.hc_get_datetime_with_tz_fold(nArray);
            }
            case 20: {
                return HashCode.hc_get_ivym_fold(new DmdbIntervalYM(byArray));
            }
            case 21: {
                return HashCode.hc_get_ivdt_fold(new DmdbIntervalDT(byArray));
            }
            case 11: {
                return HashCode.hc_get_double_fold(byArray);
            }
            case 9: {
                return HashCode.hc_get_dec_fold(byArray);
            }
            case 15: {
                return HashCode.hc_get_time_fold(byArray);
            }
            case 22: {
                int[] nArray = DmdbTimestamp.valueOf((byte[])byArray, (Column)parameter, (IDmdbConnection)dmdbConnection).dt;
                return HashCode.hc_get_time_with_tz_fold(nArray);
            }
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 19: {
                if (bl) {
                    return HashCode.hc_get_varlen_cs_fold_fnv1a(byArray);
                }
                return HashCode.hc_get_varlen_ncs_fold_fnv1a(byArray);
            }
            case 17: 
            case 18: {
                if (!dmdbConnection.compatibleMysql()) {
                    return HashCode.hc_get_varlen_cs_fold_fnv1a(byArray);
                }
                return HashCode.hc_get_binary_fold_in_sqlserver_mode(byArray);
            }
        }
        return 0L;
    }

    private static long hc_get_l4_fold(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        return ByteUtil.toLong(byArray);
    }

    private static long hc_get_int_fold(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        return ByteUtil.getUB4(byArray, 0);
    }

    private static long hc_get_int64_fold(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        return ByteUtil.getUB4(byArray, 0);
    }

    private static long hc_get_double_fold(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        return ByteUtil.getUB4(byArray, 0) + ByteUtil.getUB4(byArray, 4);
    }

    private static long hc_get_time_fold(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        return ByteUtil.getUB4(byArray, 4);
    }

    private static long hc_get_datetime_fold(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        int n2 = byArray[6] + byArray[3] | byArray[5] << 6 | byArray[4] << 12 | byArray[3] << 17 | byArray[2] << 22 | (byArray[0] & 7) << 26 | (byArray[7] & 7) << 29;
        return (long)n2 & 0xFFFFFFFFL;
    }

    private static long hc_get_ivym_fold(DmdbIntervalYM dmdbIntervalYM) {
        if (dmdbIntervalYM == null) {
            return 0L;
        }
        return dmdbIntervalYM.getYear() << 4 | dmdbIntervalYM.getMonth();
    }

    private static long hc_get_ivdt_fold(DmdbIntervalDT dmdbIntervalDT) {
        if (dmdbIntervalDT == null) {
            return 0L;
        }
        return dmdbIntervalDT.getDay() << 18 | dmdbIntervalDT.getHour() << 12 | dmdbIntervalDT.getMinute() << 6 | dmdbIntervalDT.getSecond();
    }

    private static long hc_get_varlen_cs_fold_fnv1a(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return 0L;
        }
        int n3 = 0;
        if (n2 == 1) {
            return ByteUtil.getByte(byArray, n3);
        }
        if (n2 > 0) {
            n3 = n3 + n2 - 1;
            while (byArray[n3] == 32 && n2 != 0) {
                --n3;
                --n2;
            }
        }
        return HashCode.hc_get_varlen_fold_cs_low_fnv1a(byArray, n2);
    }

    private static long hc_get_varlen_fold_cs_low_fnv1a(byte[] byArray, int n2) {
        if (n2 == 2) {
            return ByteUtil.getUB2(byArray, 0);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 ^= byArray[n4];
            n3 += (n3 << 1) + (n3 << 4) + (n3 << 7) + (n3 << 8) + (n3 << 24);
            ++n4;
        }
        return (long)n3 & 0xFFFFFFFFL;
    }

    private static long hc_get_varlen_ncs_fold_fnv1a(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return 0L;
        }
        int n3 = 0;
        if (n2 > 0) {
            n3 = n3 + n2 - 1;
            while (byArray[n3] == 32 && n2 != 0) {
                --n3;
                --n2;
            }
        }
        return HashCode.hc_get_varlen_fold_ncs_low_fnv1a(byArray, n2);
    }

    private static long hc_get_varlen_fold_ncs_low_fnv1a(byte[] byArray, int n2) {
        int n3 = 0;
        if (n2 == 1) {
            byte by = ByteUtil.getByte(byArray, 0);
            if (by > 96) {
                return by - 32;
            }
            return by;
        }
        if (n2 == 2) {
            byte by;
            byte by2 = byArray[0];
            if (by2 > 96) {
                by2 = (byte)(by2 - 32);
            }
            if ((by = byArray[1]) > 96) {
                by = (byte)(by - 32);
            }
            return (by << 8) + by2;
        }
        int n4 = 0;
        while (n4 < n2) {
            n3 = byArray[n4] > 96 ? (n3 ^= byArray[n4] - 32) : (n3 ^= byArray[n4]);
            n3 += (n3 << 1) + (n3 << 4) + (n3 << 7) + (n3 << 8) + (n3 << 24);
            ++n4;
        }
        return (long)n3 & 0xFFFFFFFFL;
    }

    private static long hc_get_datetime_with_tz_fold(int[] nArray) {
        long l2 = nArray[0];
        int n2 = nArray[1];
        long l3 = nArray[2];
        long l4 = nArray[3];
        long l5 = nArray[4];
        long l6 = nArray[5];
        long l7 = nArray[6];
        long l8 = nArray[7];
        if (l8 == 1000L) {
            l8 = 480L;
        }
        l3 = HashCode.dmtime_calc_n_days_from_zero(l2, n2, l3);
        long l9 = l4 * 60L + l5 - l8;
        long l10 = l9 / 1440L;
        l3 += l10;
        if ((l9 -= l10 * 24L * 60L) < 0L) {
            --l3;
            l9 += 1440L;
        }
        return l3 + l9 + l7 + l6;
    }

    private static long hc_get_time_with_tz_fold(int[] nArray) {
        int n2;
        int n3 = nArray[3];
        int n4 = nArray[4];
        int n5 = nArray[5];
        int n6 = nArray[6];
        int n7 = nArray[7];
        if (n7 == 1000) {
            n7 = 480;
        }
        if ((n2 = n3 * 60 + n4 - n7) < 0) {
            n2 += 1440;
        }
        return n2 + n6 + n5;
    }

    private static long dmtime_calc_n_days_from_zero(long l2, int n2, long l3) {
        if (n2 < 1 || n2 > 12 || l3 < 1L || l3 > 31L) {
            return 0L;
        }
        if (l2 < 0L) {
            long l4 = l2 * 365L + (long)global_days_befor_month[n2 - 1] + l3;
            if (n2 > 2) {
                ++l2;
            }
            long l5 = l2 / 4L;
            if (l2 == -4712L) {
                ++l5;
            }
            return l4 += l5;
        }
        long l6 = l2 * 365L + (long)global_days_befor_month[n2 - 1] + l3;
        if (n2 <= 2) {
            --l2;
        }
        long l7 = l2 < 1600L ? l2 / 4L : 400L + (l2 - 1600L) / 4L - (l2 - 1600L) / 100L + (l2 - 1600L) / 400L;
        if (l2 >= 0L) {
            ++l7;
        }
        return l6 += l7;
    }

    private static long hc_get_dec_fold(byte[] byArray) {
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = byArray.length - 1;
        while (n5 > 4) {
            n4 = (int)((long)n4 + ByteUtil.getUB4(byArray, n2));
            n2 += 4;
            n5 -= 4;
        }
        if (n5 > 0) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, n2, byArray2, 0, n5);
            n3 = ByteUtil.getInt(byArray2, 0);
        }
        return (long)(n3 + n4) & 0xFFFFFFFFL;
    }

    private static long hc_get_varlen_fold_cs_low(byte[] byArray, int n2) {
        int n3 = 1;
        int n4 = 4;
        byte by = 0;
        if (n2 == 0) {
            return n3;
        }
        if (n2 == 2) {
            return ByteUtil.getUB2(byArray, 0);
        }
        if (n2 > 64) {
            return HashCode.bfd_varlen_low_cs_max(byArray, n2);
        }
        int n5 = 0;
        while (n5 < n2) {
            by = byArray[n5];
            n3 ^= ((n3 & 0x3F) + n4) * by + (n3 << 8);
            n4 += 3;
            ++n5;
        }
        return (long)n3 & 0xFFFFFFFFL;
    }

    private static long bfd_varlen_low_cs_max(byte[] byArray, int n2) {
        int n3 = 1;
        int n4 = 4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n2 >> 6;
        n5 = 0 + (n2 >> 1) - 1;
        n6 = n5 + 1;
        int n9 = 32 + n2 % 64 / n8 / 2;
        int n10 = 0;
        while (n10 < n9) {
            n7 = n5;
            n3 ^= ((n3 & 0x3F) + n4) * byArray[n7] + (n3 << 8);
            n5 -= n8;
            n7 = n6;
            n3 ^= ((n3 & 0x3F) + (n4 += 3)) * byArray[n7] + (n3 << 8);
            n4 += 3;
            n6 += n8;
            ++n10;
        }
        return (long)n3 & 0xFFFFFFFFL;
    }

    private static long hc_get_binary_fold_in_sqlserver_mode(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return 0L;
        }
        int n3 = 0;
        if (n2 == 1) {
            return ByteUtil.getByte(byArray, n3);
        }
        if (n2 > 0) {
            n3 = n3 + n2 - 1;
            while ((byArray[n3] == 32 || byArray[n3] == 0) && n2 != 0) {
                --n3;
                --n2;
            }
        }
        return HashCode.hc_get_varlen_fold_cs_low(byArray, n2);
    }
}

