/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.redis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.result.BaseParam;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.common.util.BeanUtils;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.server.console.entity.param.GlobalLockParam;
import org.apache.seata.server.console.entity.vo.GlobalLockVO;
import org.apache.seata.server.console.exception.ConsoleException;
import org.apache.seata.server.console.impl.AbstractLockService;
import org.apache.seata.server.console.service.GlobalLockService;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.storage.redis.JedisPooledFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
@Configuration
@ConditionalOnExpression(value="#{'redis'.equals('${lockMode}')}")
public class GlobalLockRedisServiceImpl
extends AbstractLockService
implements GlobalLockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalLockRedisServiceImpl.class);

    public PageResult<GlobalLockVO> query(GlobalLockParam param) {
        int total = 0;
        PageResult.checkPage((BaseParam)param);
        if (StringUtils.isNotBlank((String)param.getXid())) {
            List globalLockVos = this.queryGlobalByXid(param.getXid());
            total = globalLockVos.size();
            return PageResult.success((List)globalLockVos, (Integer)total, (Integer)param.getPageNum(), (Integer)param.getPageSize());
        }
        if (StringUtils.isNotBlank((String)param.getTableName()) && StringUtils.isNotBlank((String)param.getPk()) && StringUtils.isNotBlank((String)param.getResourceId())) {
            String tableName = param.getTableName();
            String pk = param.getPk();
            String resourceId = param.getResourceId();
            List globalLockVos = this.queryGlobalLockByRowKey(this.buildRowKey(tableName, pk, resourceId));
            total = globalLockVos.size();
            return PageResult.success((List)globalLockVos, (Integer)total, (Integer)param.getPageNum(), (Integer)param.getPageSize());
        }
        return PageResult.failure((String)FrameworkErrorCode.ParameterRequired.getErrCode(), (String)"only three parameters of tableName,pk,resourceId or Xid are supported");
    }

    public SingleResult<Void> deleteLock(GlobalLockParam param) {
        this.checkDeleteLock(param);
        String rowKey = this.buildRowKey(param.getTableName(), param.getPk(), param.getResourceId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start to delete global lock,xid:{} branchId:{} row key:{} ", new Object[]{param.getXid(), param.getBranchId(), rowKey});
        }
        BranchSession branchSession = new BranchSession();
        branchSession.setXid(param.getXid());
        branchSession.setBranchId(Long.parseLong(param.getBranchId()));
        try {
            this.lockManager.releaseLock(branchSession);
        }
        catch (TransactionException e) {
            throw new ConsoleException((Throwable)e, String.format("delete global lock,xid:%s ,branchId:%s ,row key:%s failed", param.getXid(), param.getBranchId(), rowKey));
        }
        return SingleResult.success();
    }

    private List<GlobalLockVO> queryGlobalLockByRowKey(String buildRowKey) {
        return this.readGlobalLockByRowKey(buildRowKey);
    }

    private String buildRowKey(String tableName, String pk, String resourceId) {
        return "SEATA_ROW_LOCK_" + resourceId + "^^^" + tableName + "^^^" + pk;
    }

    private List<GlobalLockVO> queryGlobalByXid(String xid) {
        return this.readGlobalLockByXid("SEATA_GLOBAL_LOCK" + xid);
    }

    private List<GlobalLockVO> readGlobalLockByXid(String key) {
        ArrayList<GlobalLockVO> vos = new ArrayList<GlobalLockVO>();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map mapGlobalKeys = jedis.hgetAll(key);
            if (CollectionUtils.isNotEmpty((Map)mapGlobalKeys)) {
                ArrayList rowLockKeys = new ArrayList();
                mapGlobalKeys.forEach((k, v) -> rowLockKeys.addAll(Arrays.asList(v.split(";"))));
                for (String rowLoclKey : rowLockKeys) {
                    Map mapRowLockKey = jedis.hgetAll(rowLoclKey);
                    GlobalLockVO vo = (GlobalLockVO)BeanUtils.mapToObject((Map)mapRowLockKey, GlobalLockVO.class);
                    if (vo == null) continue;
                    vos.add(vo);
                }
            }
        }
        return vos;
    }

    private List<GlobalLockVO> readGlobalLockByRowKey(String key) {
        ArrayList<GlobalLockVO> vos = new ArrayList<GlobalLockVO>();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map map = jedis.hgetAll(key);
            GlobalLockVO vo = (GlobalLockVO)BeanUtils.mapToObject((Map)map, GlobalLockVO.class);
            if (vo != null) {
                vos.add(vo);
            }
        }
        return vos;
    }

    private String buildXidLockKey(String xid) {
        return "SEATA_GLOBAL_LOCK" + xid;
    }
}

