/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.partition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.ColumnList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Binary;

public class Partition {
    private final List<TsBlock> tsBlocks;
    private int cachedPositionCount = -1;

    public Partition(List<TsBlock> tsBlocks, int startIndexInFirstBlock, int endIndexInLastBlock) {
        if (tsBlocks.size() == 1) {
            int length = endIndexInLastBlock - startIndexInFirstBlock;
            this.tsBlocks = Collections.singletonList(tsBlocks.get(0).getRegion(startIndexInFirstBlock, length));
            return;
        }
        this.tsBlocks = new ArrayList<TsBlock>(tsBlocks.size());
        TsBlock firstBlock = tsBlocks.get(0).subTsBlock(startIndexInFirstBlock);
        this.tsBlocks.add(firstBlock);
        for (int i = 1; i < tsBlocks.size() - 1; ++i) {
            this.tsBlocks.add(tsBlocks.get(i));
        }
        TsBlock lastBlock = tsBlocks.get(tsBlocks.size() - 1).getRegion(0, endIndexInLastBlock);
        this.tsBlocks.add(lastBlock);
    }

    public int getPositionCount() {
        if (this.cachedPositionCount == -1) {
            this.cachedPositionCount = 0;
            for (TsBlock block : this.tsBlocks) {
                this.cachedPositionCount += block.getPositionCount();
            }
        }
        return this.cachedPositionCount;
    }

    public int getValueColumnCount() {
        return this.tsBlocks.get(0).getValueColumnCount();
    }

    public TsBlock getTsBlock(int tsBlockIndex) {
        return this.tsBlocks.get(tsBlockIndex);
    }

    public List<Column[]> getAllColumns() {
        ArrayList<Column[]> allColumns = new ArrayList<Column[]>();
        for (TsBlock block : this.tsBlocks) {
            allColumns.add(block.getAllColumns());
        }
        return allColumns;
    }

    public boolean getBoolean(int channel, int rowIndex) {
        PartitionIndex partitionIndex = this.getPartitionIndex(rowIndex);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.tsBlocks.get(tsBlockIndex);
        return tsBlock.getColumn(channel).getBoolean(offsetInTsBlock);
    }

    public int getInt(int channel, int rowIndex) {
        PartitionIndex partitionIndex = this.getPartitionIndex(rowIndex);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.tsBlocks.get(tsBlockIndex);
        return tsBlock.getColumn(channel).getInt(offsetInTsBlock);
    }

    public long getLong(int channel, int rowIndex) {
        PartitionIndex partitionIndex = this.getPartitionIndex(rowIndex);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.tsBlocks.get(tsBlockIndex);
        return tsBlock.getColumn(channel).getLong(offsetInTsBlock);
    }

    public float getFloat(int channel, int rowIndex) {
        PartitionIndex partitionIndex = this.getPartitionIndex(rowIndex);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.tsBlocks.get(tsBlockIndex);
        return tsBlock.getColumn(channel).getFloat(offsetInTsBlock);
    }

    public double getDouble(int channel, int rowIndex) {
        PartitionIndex partitionIndex = this.getPartitionIndex(rowIndex);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.tsBlocks.get(tsBlockIndex);
        return tsBlock.getColumn(channel).getDouble(offsetInTsBlock);
    }

    public Binary getBinary(int channel, int rowIndex) {
        PartitionIndex partitionIndex = this.getPartitionIndex(rowIndex);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.tsBlocks.get(tsBlockIndex);
        return tsBlock.getColumn(channel).getBinary(offsetInTsBlock);
    }

    public boolean isNull(int channel, int rowIndex) {
        PartitionIndex partitionIndex = this.getPartitionIndex(rowIndex);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.tsBlocks.get(tsBlockIndex);
        return tsBlock.getColumn(channel).isNull(offsetInTsBlock);
    }

    public void writeTo(ColumnBuilder builder, int channel, int rowIndex) {
        PartitionIndex partitionIndex = this.getPartitionIndex(rowIndex);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        Column column = this.tsBlocks.get(tsBlockIndex).getColumn(channel);
        builder.write(column, offsetInTsBlock);
    }

    public Partition getRegion(int start, int end) {
        PartitionIndex startPartitionIndex = this.getPartitionIndex(start);
        PartitionIndex endPartitionIndex = this.getPartitionIndex(end);
        ArrayList<TsBlock> tsBlockList = new ArrayList<TsBlock>();
        int startTsBlockIndex = startPartitionIndex.getTsBlockIndex();
        int endTsBlockIndex = endPartitionIndex.getTsBlockIndex();
        for (int i = startTsBlockIndex; i <= endTsBlockIndex; ++i) {
            tsBlockList.add(this.tsBlocks.get(i));
        }
        int startIndexInFirstBlock = startPartitionIndex.getOffsetInTsBlock();
        int endIndexInLastBlock = endPartitionIndex.getOffsetInTsBlock();
        return new Partition(tsBlockList, startIndexInFirstBlock, endIndexInLastBlock + 1);
    }

    public PartitionIndex getPartitionIndex(int rowIndex) {
        int tsBlockIndex;
        for (tsBlockIndex = 0; tsBlockIndex < this.tsBlocks.size() && rowIndex >= this.tsBlocks.get(tsBlockIndex).getPositionCount(); rowIndex -= this.tsBlocks.get(tsBlockIndex).getPositionCount(), ++tsBlockIndex) {
        }
        if (tsBlockIndex != this.tsBlocks.size()) {
            return new PartitionIndex(tsBlockIndex, rowIndex);
        }
        throw new IndexOutOfBoundsException("Index out of Partition's bounds!");
    }

    public List<ColumnList> getSortedColumnList(List<Integer> sortedChannels) {
        ArrayList<ColumnList> columnLists = new ArrayList<ColumnList>();
        for (Integer sortedChannel : sortedChannels) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (TsBlock tsBlock : this.tsBlocks) {
                columns.add(tsBlock.getColumn(sortedChannel.intValue()));
            }
            columnLists.add(new ColumnList(columns));
        }
        return columnLists;
    }

    public static class PartitionIndex {
        private final int tsBlockIndex;
        private final int offsetInTsBlock;

        PartitionIndex(int tsBlockIndex, int offsetInTsBlock) {
            this.tsBlockIndex = tsBlockIndex;
            this.offsetInTsBlock = offsetInTsBlock;
        }

        public int getTsBlockIndex() {
            return this.tsBlockIndex;
        }

        public int getOffsetInTsBlock() {
            return this.offsetInTsBlock;
        }
    }
}

