/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.utils.io.BufferSerializable;
import org.apache.iotdb.db.utils.io.StreamSerializable;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class IDPredicate
implements StreamSerializable,
BufferSerializable {
    protected final IDPredicateType type;

    public int serializedSize() {
        return 1;
    }

    protected IDPredicate(IDPredicateType type) {
        this.type = type;
    }

    public abstract boolean matches(IDeviceID var1);

    @Override
    public long serialize(OutputStream stream) throws IOException {
        return this.type.serialize(stream);
    }

    @Override
    public long serialize(ByteBuffer buffer) {
        return this.type.serialize(buffer);
    }

    public static IDPredicate createFrom(ByteBuffer buffer) {
        IDPredicate predicate;
        IDPredicateType type = IDPredicateType.deserialize(buffer);
        if (Objects.requireNonNull(type) == IDPredicateType.NOP) {
            predicate = new NOP();
        } else if (Objects.requireNonNull(type) == IDPredicateType.FULL_EXACT_MATCH) {
            predicate = new FullExactMatch();
        } else if (Objects.requireNonNull(type) == IDPredicateType.SEGMENT_EXACT_MATCH) {
            predicate = new SegmentExactMatch();
        } else if (Objects.requireNonNull(type) == IDPredicateType.AND) {
            predicate = new And(new IDPredicate[0]);
        } else {
            throw new IllegalArgumentException("Unrecognized predicate type: " + (Object)((Object)type));
        }
        predicate.deserialize(buffer);
        return predicate;
    }

    public static IDPredicate createFrom(InputStream stream) throws IOException {
        IDPredicate predicate;
        IDPredicateType type = IDPredicateType.deserialize(stream);
        if (Objects.requireNonNull(type) == IDPredicateType.NOP) {
            predicate = new NOP();
        } else if (Objects.requireNonNull(type) == IDPredicateType.FULL_EXACT_MATCH) {
            predicate = new FullExactMatch();
        } else if (Objects.requireNonNull(type) == IDPredicateType.SEGMENT_EXACT_MATCH) {
            predicate = new SegmentExactMatch();
        } else if (Objects.requireNonNull(type) == IDPredicateType.AND) {
            predicate = new And(new IDPredicate[0]);
        } else {
            throw new IllegalArgumentException("Unrecognized predicate type: " + (Object)((Object)type));
        }
        predicate.deserialize(stream);
        return predicate;
    }

    public static enum IDPredicateType {
        NOP,
        FULL_EXACT_MATCH,
        SEGMENT_EXACT_MATCH,
        AND;


        public long serialize(OutputStream stream) throws IOException {
            stream.write((byte)this.ordinal());
            return 1L;
        }

        public long serialize(ByteBuffer buffer) {
            buffer.put((byte)this.ordinal());
            return 1L;
        }

        public static IDPredicateType deserialize(InputStream stream) throws IOException {
            return IDPredicateType.values()[stream.read()];
        }

        public static IDPredicateType deserialize(ByteBuffer buffer) {
            return IDPredicateType.values()[buffer.get()];
        }
    }

    public static class NOP
    extends IDPredicate {
        public NOP() {
            super(IDPredicateType.NOP);
        }

        @Override
        public void deserialize(InputStream stream) {
        }

        @Override
        public void deserialize(ByteBuffer buffer) {
        }

        @Override
        public boolean matches(IDeviceID deviceID) {
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof NOP;
        }

        public String toString() {
            return "NOP";
        }
    }

    public static class FullExactMatch
    extends IDPredicate {
        private IDeviceID deviceID;

        public FullExactMatch(IDeviceID deviceID) {
            super(IDPredicateType.FULL_EXACT_MATCH);
            this.deviceID = deviceID;
        }

        public FullExactMatch() {
            super(IDPredicateType.FULL_EXACT_MATCH);
        }

        @Override
        public int serializedSize() {
            return super.serializedSize() + this.deviceID.serializedSize();
        }

        @Override
        public long serialize(OutputStream stream) throws IOException {
            long size = super.serialize(stream);
            return size += (long)this.deviceID.serialize(stream);
        }

        @Override
        public long serialize(ByteBuffer buffer) {
            long size = super.serialize(buffer);
            return size += (long)this.deviceID.serialize(buffer);
        }

        @Override
        public void deserialize(InputStream stream) throws IOException {
            this.deviceID = IDeviceID.Deserializer.DEFAULT_DESERIALIZER.deserializeFrom(stream);
        }

        @Override
        public void deserialize(ByteBuffer buffer) {
            this.deviceID = IDeviceID.Deserializer.DEFAULT_DESERIALIZER.deserializeFrom(buffer);
        }

        @Override
        public boolean matches(IDeviceID deviceID) {
            return this.deviceID.equals(deviceID);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FullExactMatch that = (FullExactMatch)o;
            return Objects.equals(this.deviceID, that.deviceID);
        }

        public int hashCode() {
            return Objects.hashCode(this.deviceID);
        }

        public String toString() {
            return "FullExactMatch{deviceID=" + this.deviceID + '}';
        }
    }

    public static class SegmentExactMatch
    extends IDPredicate {
        private String pattern;
        private int segmentIndex;

        public SegmentExactMatch(String pattern, int segmentIndex) {
            super(IDPredicateType.SEGMENT_EXACT_MATCH);
            this.pattern = pattern;
            this.segmentIndex = segmentIndex;
        }

        public SegmentExactMatch() {
            super(IDPredicateType.SEGMENT_EXACT_MATCH);
        }

        @Override
        public int serializedSize() {
            if (this.pattern != null) {
                byte[] bytes = this.pattern.getBytes(TSFileConfig.STRING_CHARSET);
                return super.serializedSize() + ReadWriteForEncodingUtils.varIntSize((int)bytes.length) + bytes.length * 2 + ReadWriteForEncodingUtils.varIntSize((int)this.segmentIndex);
            }
            return ReadWriteForEncodingUtils.varIntSize((int)-1);
        }

        @Override
        public long serialize(OutputStream stream) throws IOException {
            long size = super.serialize(stream);
            size += (long)ReadWriteIOUtils.writeVar((String)this.pattern, (OutputStream)stream);
            return size += (long)ReadWriteForEncodingUtils.writeVarInt((int)this.segmentIndex, (OutputStream)stream);
        }

        @Override
        public long serialize(ByteBuffer buffer) {
            long size = super.serialize(buffer);
            size += (long)ReadWriteIOUtils.writeVar((String)this.pattern, (ByteBuffer)buffer);
            return size += (long)ReadWriteForEncodingUtils.writeVarInt((int)this.segmentIndex, (ByteBuffer)buffer);
        }

        @Override
        public void deserialize(InputStream stream) throws IOException {
            this.pattern = ReadWriteIOUtils.readVarIntString((InputStream)stream);
            this.segmentIndex = ReadWriteForEncodingUtils.readVarInt((InputStream)stream);
        }

        @Override
        public void deserialize(ByteBuffer buffer) {
            this.pattern = ReadWriteIOUtils.readVarIntString((ByteBuffer)buffer);
            this.segmentIndex = ReadWriteForEncodingUtils.readVarInt((ByteBuffer)buffer);
        }

        @Override
        public boolean matches(IDeviceID deviceID) {
            return Objects.equals(this.pattern, deviceID.segment(this.segmentIndex));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SegmentExactMatch that = (SegmentExactMatch)o;
            return this.segmentIndex == that.segmentIndex && Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.segmentIndex);
        }

        public String toString() {
            return "SegmentExactMatch{pattern='" + this.pattern + '\'' + ", segmentIndex=" + this.segmentIndex + '}';
        }
    }

    public static class And
    extends IDPredicate {
        private final List<IDPredicate> predicates = new ArrayList<IDPredicate>();

        public And(IDPredicate ... predicates) {
            super(IDPredicateType.AND);
            Collections.addAll(this.predicates, predicates);
        }

        public void add(IDPredicate predicate) {
            this.predicates.add(predicate);
        }

        @Override
        public int serializedSize() {
            int serializedSize = super.serializedSize();
            serializedSize += ReadWriteForEncodingUtils.varIntSize((int)this.predicates.size());
            for (IDPredicate predicate : this.predicates) {
                serializedSize += predicate.serializedSize();
            }
            return serializedSize;
        }

        @Override
        public long serialize(OutputStream stream) throws IOException {
            long size = super.serialize(stream);
            size += (long)ReadWriteForEncodingUtils.writeVarInt((int)this.predicates.size(), (OutputStream)stream);
            for (IDPredicate predicate : this.predicates) {
                size += predicate.serialize(stream);
            }
            return size;
        }

        @Override
        public long serialize(ByteBuffer buffer) {
            long size = super.serialize(buffer);
            size += (long)ReadWriteForEncodingUtils.writeVarInt((int)this.predicates.size(), (ByteBuffer)buffer);
            for (IDPredicate predicate : this.predicates) {
                size += predicate.serialize(buffer);
            }
            return size;
        }

        @Override
        public void deserialize(InputStream stream) throws IOException {
            int size = ReadWriteForEncodingUtils.readVarInt((InputStream)stream);
            for (int i = 0; i < size; ++i) {
                this.predicates.add(IDPredicate.createFrom(stream));
            }
        }

        @Override
        public void deserialize(ByteBuffer buffer) {
            int size = ReadWriteForEncodingUtils.readVarInt((ByteBuffer)buffer);
            for (int i = 0; i < size; ++i) {
                this.predicates.add(IDPredicate.createFrom(buffer));
            }
        }

        @Override
        public boolean matches(IDeviceID deviceID) {
            return this.predicates.stream().allMatch(predicate -> predicate.matches(deviceID));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            And and = (And)o;
            return Objects.equals(this.predicates, and.predicates);
        }

        public int hashCode() {
            return Objects.hashCode(this.predicates);
        }

        public String toString() {
            return "And{predicates=" + this.predicates + '}';
        }
    }
}

