/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import java.util.ArrayList;
import org.apache.iotdb.library.drepair.util.ValueFill;
import org.apache.iotdb.udf.api.access.RowIterator;

public class LikelihoodFill
extends ValueFill {
    private double stopErrorRatio = 1.0E-4;
    private int stopIteration = Integer.MAX_VALUE;

    public LikelihoodFill(RowIterator dataIterator) throws Exception {
        super(dataIterator);
    }

    @Override
    public void fill() {
        ArrayList<Integer> repairIndexList = new ArrayList<Integer>();
        ArrayList<Double> repairValueList = new ArrayList<Double>();
        int previousNotNaN = -1;
        for (int i = 0; i < this.n; ++i) {
            if (Double.isNaN(this.original[i])) {
                repairIndexList.add(i);
                this.repaired[i] = this.original[i];
                continue;
            }
            if (previousNotNaN >= 0 && previousNotNaN + 1 != i) {
                double delta = (this.original[i] - this.original[previousNotNaN]) / (double)(this.time[i] - this.time[previousNotNaN]);
                for (int j = previousNotNaN + 1; j < i; ++j) {
                    this.repaired[j] = this.original[previousNotNaN] + delta * (double)(this.time[j] - this.time[previousNotNaN]);
                    repairValueList.add(this.repaired[j]);
                }
            }
            this.repaired[i] = this.original[i];
            previousNotNaN = i;
        }
        double errorRatio = 1.0;
        for (int iteration = 0; errorRatio > this.stopErrorRatio && iteration < this.stopIteration; ++iteration) {
            int currentIndex;
            int i;
            errorRatio = 0.0;
            for (i = 0; i < repairIndexList.size(); ++i) {
                currentIndex = (Integer)repairIndexList.get(i);
                if (currentIndex == 0 || Double.isNaN(this.repaired[currentIndex - 1]) || currentIndex == this.n - 1 || Double.isNaN(this.repaired[currentIndex + 1])) continue;
                double intervalPrev1 = this.time[currentIndex] - this.time[currentIndex - 1];
                double intervalPost1 = this.time[currentIndex + 1] - this.time[currentIndex];
                double squareAPrev = 0.0;
                double squareBPrev = 0.0;
                if (currentIndex >= 2 && !Double.isNaN(this.repaired[currentIndex - 2])) {
                    double intervalPrev2 = this.time[currentIndex - 2] - this.time[currentIndex - 1];
                    squareAPrev = 1.0 / (intervalPrev1 * intervalPrev1);
                    squareBPrev = 2.0 * this.repaired[currentIndex - 2] / (intervalPrev2 * intervalPrev1) - 2.0 * (intervalPrev2 + intervalPrev1) * this.repaired[currentIndex - 1] / (intervalPrev2 * intervalPrev1 * intervalPrev1);
                }
                double squareACurr = (intervalPrev1 + intervalPost1) * (intervalPrev1 + intervalPost1) / (intervalPrev1 * intervalPrev1 * intervalPost1 * intervalPost1);
                double squareBCurr = -2.0 * (intervalPrev1 + intervalPost1) * this.repaired[currentIndex - 1] / (intervalPrev1 * intervalPrev1 * intervalPost1) - 2.0 * (intervalPrev1 + intervalPost1) * this.repaired[currentIndex + 1] / (intervalPrev1 * intervalPost1 * intervalPost1);
                double squareAPost = 0.0;
                double squareBPost = 0.0;
                if (currentIndex <= this.n - 3 && !Double.isNaN(this.repaired[currentIndex + 2])) {
                    double intervalPost2 = this.time[currentIndex + 2] - this.time[currentIndex + 1];
                    squareAPost = 1.0 / (intervalPost1 * intervalPost1);
                    squareBPost = 2.0 * this.repaired[currentIndex + 2] / (intervalPost1 * intervalPost2) - 2.0 * (intervalPost1 + intervalPost2) * this.repaired[currentIndex + 1] / (intervalPost1 * intervalPost1 * intervalPost2);
                }
                repairValueList.set(i, -(squareBPrev + squareBCurr + squareBPost) / (2.0 * (squareAPrev + squareACurr + squareAPost)));
            }
            for (i = 0; i < repairIndexList.size(); ++i) {
                currentIndex = (Integer)repairIndexList.get(i);
                double previousRepair = this.repaired[currentIndex];
                double updatedRepair = (Double)repairValueList.get(i);
                double updatedRatio = Math.abs(updatedRepair - previousRepair) / previousRepair;
                errorRatio = Math.max(updatedRatio, errorRatio);
                this.repaired[currentIndex] = updatedRepair;
            }
        }
    }
}

