/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cache.GrowingLRUMap;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlListener;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.UnmodifiableAccessControlList;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLTemplate;
import org.apache.jackrabbit.core.security.authorization.principalbased.EntriesCache;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLProvider
extends AbstractAccessControlProvider
implements AccessControlConstants {
    private static Logger log = LoggerFactory.getLogger(ACLProvider.class);
    private NodeImpl acRoot;
    private ACLEditor editor;
    private EntriesCache entriesCache;

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        NodeImpl root = (NodeImpl)this.session.getRootNode();
        if (root.hasNode(N_ACCESSCONTROL)) {
            this.acRoot = root.getNode(N_ACCESSCONTROL);
            if (!this.acRoot.isNodeType(NT_REP_ACCESS_CONTROL)) {
                throw new RepositoryException("Error while initializing Access Control Provider: Found ac-root to be wrong node type " + this.acRoot.getPrimaryNodeType().getName());
            }
        } else {
            this.acRoot = root.addNode(N_ACCESSCONTROL, NT_REP_ACCESS_CONTROL, null);
        }
        this.editor = new ACLEditor(this.session, this.session.getQPath(this.acRoot.getPath()));
        this.entriesCache = new EntriesCache(this.session, this.editor, this.acRoot.getPath());
        if (!configuration.containsKey("omit-default-permission")) {
            try {
                log.debug("Install initial permissions: ...");
                ValueFactory vf = this.session.getValueFactory();
                HashMap<String, Value> restrictions = new HashMap<String, Value>();
                restrictions.put(this.session.getJCRName(ACLTemplate.P_NODE_PATH), vf.createValue(root.getPath(), 8));
                PrincipalManager pMgr = this.session.getPrincipalManager();
                AccessControlManager acMgr = this.session.getAccessControlManager();
                String pName = "administrators";
                if (pMgr.hasPrincipal(pName)) {
                    Principal administrators = pMgr.getPrincipal(pName);
                    ACLProvider.installDefaultPermissions(administrators, new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")}, restrictions, this.editor);
                } else {
                    log.info("Administrators principal group is missing -> Not adding default permissions.");
                }
                ACLProvider.installDefaultPermissions(pMgr.getEveryone(), new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")}, restrictions, this.editor);
                this.session.save();
            }
            catch (RepositoryException e) {
                log.error("Failed to set-up minimal access control for root node of workspace " + this.session.getWorkspace().getName());
                this.session.getRootNode().refresh(false);
            }
        }
    }

    private static void installDefaultPermissions(Principal principal, Privilege[] privs, Map<String, Value> restrictions, AccessControlEditor editor) throws RepositoryException, AccessControlException {
        JackrabbitAccessControlPolicy[] acls = editor.editAccessControlPolicies(principal);
        if (acls.length > 0) {
            ACLTemplate acl = (ACLTemplate)acls[0];
            if (acl.isEmpty()) {
                acl.addEntry(principal, privs, true, restrictions);
                editor.setPolicy(acl.getPath(), acl);
            } else {
                log.debug("... policy for principal '" + principal.getName() + "' already present.");
            }
        } else {
            log.debug("... policy for principal  '" + principal.getName() + "'  already present.");
        }
    }

    @Override
    public void close() {
        super.close();
        this.entriesCache.close();
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Path absPath, CompiledPermissions permissions) throws ItemNotFoundException, RepositoryException {
        QueryResult result;
        if (absPath == null) {
            log.warn("TODO: JCR-2774 - Repository level permissions.");
            return new AccessControlPolicy[0];
        }
        String jcrPath = this.session.getJCRPath(absPath);
        String pName = ISO9075.encode(this.session.getJCRName(ACLTemplate.P_NODE_PATH));
        int ancestorCnt = absPath.getAncestorCount();
        StringBuilder stmt = new StringBuilder("/jcr:root");
        stmt.append(this.acRoot.getPath());
        stmt.append("//element(*,");
        stmt.append(this.session.getJCRName(NT_REP_ACE));
        stmt.append(")[");
        for (int i = 0; i <= ancestorCnt; ++i) {
            String path = Text.getRelativeParent(jcrPath, i);
            if (i > 0) {
                stmt.append(" or ");
            }
            stmt.append("@");
            stmt.append(pName);
            stmt.append("='");
            stmt.append(path.replaceAll("'", "''"));
            stmt.append("'");
        }
        stmt.append("]");
        try {
            QueryManager qm = this.session.getWorkspace().getQueryManager();
            Query q = qm.createQuery(stmt.toString(), "xpath");
            result = q.execute();
        }
        catch (RepositoryException e) {
            log.error("Unexpected error while searching effective policies. {}", (Object)e.getMessage());
            throw new UnsupportedOperationException("Retrieve effective policies at absPath '" + jcrPath + "' not supported.", e);
        }
        LinkedHashSet<UnmodifiableAccessControlList> acls = new LinkedHashSet<UnmodifiableAccessControlList>();
        NodeIterator it = result.getNodes();
        block3: while (it.hasNext()) {
            Node aceNode = it.nextNode();
            String accessControlledNodePath = Text.getRelativeParent(aceNode.getPath(), 2);
            Path acPath = this.session.getQPath(accessControlledNodePath);
            AccessControlPolicy[] policies = this.editor.getPolicies(accessControlledNodePath);
            if (policies.length <= 0) continue;
            ACLTemplate acl = (ACLTemplate)policies[0];
            for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                ACLTemplate.Entry entry = (ACLTemplate.Entry)ace;
                if (!entry.matches(jcrPath)) continue;
                if (permissions.grants(acPath, 32)) {
                    acls.add(new UnmodifiableAccessControlList(acl));
                    continue block3;
                }
                throw new AccessDeniedException("Access denied at " + accessControlledNodePath);
            }
        }
        return acls.toArray(new AccessControlPolicy[acls.size()]);
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals, CompiledPermissions permissions) throws RepositoryException {
        ArrayList<UnmodifiableAccessControlList> acls = new ArrayList<UnmodifiableAccessControlList>(principals.size());
        for (Principal principal : principals) {
            ACLTemplate acl = this.editor.getACL(principal);
            if (acl == null) continue;
            if (permissions.grants(this.session.getQPath(acl.getPath()), 32)) {
                acls.add(new UnmodifiableAccessControlList(acl));
                continue;
            }
            throw new AccessDeniedException("Access denied at " + acl.getPath());
        }
        return acls.toArray(new AccessControlPolicy[acls.size()]);
    }

    @Override
    public AccessControlEditor getEditor(Session editingSession) {
        this.checkInitialized();
        if (editingSession instanceof SessionImpl) {
            try {
                return new ACLEditor((SessionImpl)editingSession, this.session.getQPath(this.acRoot.getPath()));
            }
            catch (RepositoryException e) {
                log.error("Internal error: {}", (Object)e.getMessage());
            }
        }
        log.debug("Unable to build access control editor " + ACLEditor.class.getName() + ".");
        return null;
    }

    @Override
    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        if (this.isReadOnly(principals)) {
            return this.getReadOnlyPermissions();
        }
        return new CompiledPermissionImpl(principals);
    }

    @Override
    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        CompiledPermissionImpl cp = new CompiledPermissionImpl(principals, false);
        return cp.canRead(((NodeImpl)this.session.getRootNode()).getPrimaryPath());
    }

    private class CompiledPermissionImpl
    extends AbstractCompiledPermissions
    implements AccessControlListener {
        private final Set<Principal> principals;
        private final Set<String> acPaths;
        private List<AccessControlEntry> entries;
        private boolean canReadAll;
        private final Map<ItemId, Boolean> readCache = new GrowingLRUMap<ItemId, Boolean>(1024, 5000);
        private final Object monitor = new Object();

        private CompiledPermissionImpl(Set<Principal> principals) throws RepositoryException {
            this(principals, true);
        }

        private CompiledPermissionImpl(Set<Principal> principals, boolean listenToEvents) throws RepositoryException {
            this.principals = principals;
            this.acPaths = new HashSet<String>(principals.size());
            this.reload();
            if (listenToEvents) {
                ACLProvider.this.entriesCache.addListener(this);
            }
        }

        private void reload() throws RepositoryException {
            this.acPaths.clear();
            for (Principal p : this.principals) {
                this.acPaths.add(ACLProvider.this.editor.getPathToAcNode(p));
            }
            this.entries = ACLProvider.this.entriesCache.getEntries(this.principals);
            this.canReadAll = this.canRead(ACLProvider.this.session.getQPath("/"));
            if (this.canReadAll) {
                for (AccessControlEntry entry : this.entries) {
                    AccessControlEntryImpl ace = (AccessControlEntryImpl)entry;
                    if (ace.isAllow() || !ace.getPrivilegeBits().includesRead()) continue;
                    this.canReadAll = false;
                    break;
                }
            }
        }

        @Override
        protected synchronized AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            if (!absPath.isAbsolute()) {
                throw new RepositoryException("Absolute path expected.");
            }
            boolean isAcItem = ACLProvider.this.isAcItem(absPath);
            String jcrPath = ACLProvider.this.session.getJCRPath(absPath);
            return this.buildResult(jcrPath, isAcItem);
        }

        @Override
        protected AbstractCompiledPermissions.Result buildRepositoryResult() throws RepositoryException {
            log.warn("TODO: JCR-2774 - Repository level permissions.");
            PrivilegeManagerImpl pm = this.getPrivilegeManagerImpl();
            return new AbstractCompiledPermissions.Result(0, 0, PrivilegeBits.EMPTY, PrivilegeBits.EMPTY);
        }

        @Override
        protected PrivilegeManagerImpl getPrivilegeManagerImpl() throws RepositoryException {
            return ACLProvider.this.getPrivilegeManagerImpl();
        }

        private AbstractCompiledPermissions.Result buildResult(String targetPath, boolean isAcItem) throws RepositoryException {
            int allows = 0;
            int denies = 0;
            PrivilegeBits allowBits = PrivilegeBits.getInstance();
            PrivilegeBits denyBits = PrivilegeBits.getInstance();
            PrivilegeBits parentAllowBits = PrivilegeBits.getInstance();
            PrivilegeBits parentDenyBits = PrivilegeBits.getInstance();
            String parentPath = Text.getRelativeParent(targetPath, 1);
            for (AccessControlEntry entry : this.entries) {
                int permissions;
                boolean matches;
                if (!(entry instanceof ACLTemplate.Entry)) {
                    log.warn("Unexpected AccessControlEntry instance -> ignore");
                    continue;
                }
                ACLTemplate.Entry entr = (ACLTemplate.Entry)entry;
                PrivilegeBits privs = entr.getPrivilegeBits();
                if (!"".equals(parentPath) && entr.matches(parentPath)) {
                    if (entr.isAllow()) {
                        parentAllowBits.addDifference(privs, parentDenyBits);
                    } else {
                        parentDenyBits.addDifference(privs, parentAllowBits);
                    }
                }
                if (!(matches = entr.matches(targetPath))) continue;
                if (entr.isAllow()) {
                    allowBits.addDifference(privs, denyBits);
                    permissions = PrivilegeRegistry.calculatePermissions(allowBits, parentAllowBits, true, isAcItem);
                    allows |= Permission.diff(permissions, denies);
                    continue;
                }
                denyBits.addDifference(privs, allowBits);
                permissions = PrivilegeRegistry.calculatePermissions(denyBits, parentDenyBits, false, isAcItem);
                denies |= Permission.diff(permissions, allows);
            }
            return new AbstractCompiledPermissions.Result(allows, denies, allowBits, denyBits);
        }

        @Override
        public void close() {
            ACLProvider.this.entriesCache.removeListener(this);
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canRead(Path path, ItemId itemId) throws RepositoryException {
            boolean canRead;
            if (path == null) {
                Object object = this.monitor;
                synchronized (object) {
                    if (!this.readCache.containsKey(itemId)) {
                        boolean canRead2 = this.canRead(ACLProvider.this.session.getHierarchyManager().getPath(itemId));
                        this.readCache.put(itemId, canRead2);
                        return canRead2;
                    }
                    canRead = this.readCache.get(itemId);
                }
            } else {
                canRead = this.canRead(path);
            }
            return canRead;
        }

        private boolean canRead(Path path) throws RepositoryException {
            return this.canReadAll && !ACLProvider.this.isAcItem(path) || this.grants(path, 1);
        }

        @Override
        public void acModified(AccessControlModifications modifications) {
            try {
                boolean reload = false;
                Iterator keys = modifications.getNodeIdentifiers().iterator();
                while (keys.hasNext() && !reload) {
                    String path = keys.next().toString();
                    reload = this.acPaths.contains(path);
                }
                if (reload) {
                    this.clearCache();
                    this.reload();
                }
            }
            catch (RepositoryException e) {
                log.warn("Internal error: {}", (Object)e.getMessage());
            }
        }
    }
}

