/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDefinitionProviderImpl
implements ItemDefinitionProvider {
    private static Logger log = LoggerFactory.getLogger(ItemDefinitionProviderImpl.class);
    private final EffectiveNodeTypeProvider entProvider;
    private final RepositoryService service;
    private final SessionInfo sessionInfo;
    private QNodeDefinition rootNodeDefinition;

    public ItemDefinitionProviderImpl(EffectiveNodeTypeProvider entProvider, RepositoryService service, SessionInfo sessionInfo) {
        this.entProvider = entProvider;
        this.service = service;
        this.sessionInfo = sessionInfo;
    }

    @Override
    public QNodeDefinition getRootNodeDefinition() throws RepositoryException {
        if (this.rootNodeDefinition == null) {
            IdFactory idFactory = this.service.getIdFactory();
            PathFactory pf = this.service.getPathFactory();
            this.rootNodeDefinition = this.service.getNodeDefinition(this.sessionInfo, idFactory.createNodeId((String)null, pf.getRootPath()));
        }
        return this.rootNodeDefinition;
    }

    @Override
    public QNodeDefinition getQNodeDefinition(Name[] parentNodeTypeNames, Name nodeName, Name ntName, NodeId nodeId) throws RepositoryException {
        QNodeDefinition definition;
        if (parentNodeTypeNames == null) {
            return this.getRootNodeDefinition();
        }
        try {
            EffectiveNodeType ent = this.entProvider.getEffectiveNodeType(parentNodeTypeNames);
            EffectiveNodeType entTarget = this.getEffectiveNodeType(ntName);
            definition = ItemDefinitionProviderImpl.getQNodeDefinition(ent, entTarget, nodeName);
        }
        catch (RepositoryException e) {
            log.debug("Cannot determine effective node type of {}: {}", (Object)nodeId, (Object)e);
            definition = ItemDefinitionProviderImpl.getNodeDefinition(this.service, this.sessionInfo, nodeId);
        }
        return definition;
    }

    @Override
    public QNodeDefinition getQNodeDefinition(Name[] parentNodeTypeNames, Name name, Name nodeTypeName) throws NoSuchNodeTypeException, ConstraintViolationException {
        EffectiveNodeType ent = this.entProvider.getEffectiveNodeType(parentNodeTypeNames);
        EffectiveNodeType entTarget = this.getEffectiveNodeType(nodeTypeName);
        return ItemDefinitionProviderImpl.getQNodeDefinition(ent, entTarget, name);
    }

    @Override
    public QNodeDefinition getQNodeDefinition(EffectiveNodeType ent, Name name, Name nodeTypeName) throws NoSuchNodeTypeException, ConstraintViolationException {
        EffectiveNodeType entTarget = this.getEffectiveNodeType(nodeTypeName);
        return ItemDefinitionProviderImpl.getQNodeDefinition(ent, entTarget, name);
    }

    @Override
    public QPropertyDefinition getQPropertyDefinition(Name[] parentNodeTypeNames, Name propertyName, int propertyType, boolean isMultiValued, PropertyId propertyId) throws RepositoryException {
        QPropertyDefinition definition;
        try {
            EffectiveNodeType ent = this.entProvider.getEffectiveNodeType(parentNodeTypeNames);
            definition = ItemDefinitionProviderImpl.getQPropertyDefinition(ent, propertyName, propertyType, isMultiValued, true);
        }
        catch (RepositoryException e) {
            log.debug("Cannot determine property definition of {}: {}", (Object)propertyId, (Object)e);
            definition = ItemDefinitionProviderImpl.getPropertyDefinition(this.service, this.sessionInfo, propertyId);
        }
        return definition;
    }

    @Override
    public QPropertyDefinition getQPropertyDefinition(Name ntName, Name propName, int type, boolean multiValued) throws ConstraintViolationException, NoSuchNodeTypeException {
        EffectiveNodeType ent = this.entProvider.getEffectiveNodeType(ntName);
        return ItemDefinitionProviderImpl.getQPropertyDefinition(ent, propName, type, multiValued, false);
    }

    @Override
    public QPropertyDefinition getQPropertyDefinition(Name[] parentNodeTypeNames, Name name, int type, boolean multiValued) throws ConstraintViolationException, NoSuchNodeTypeException {
        EffectiveNodeType ent = this.entProvider.getEffectiveNodeType(parentNodeTypeNames);
        return ItemDefinitionProviderImpl.getQPropertyDefinition(ent, name, type, multiValued, false);
    }

    @Override
    public QPropertyDefinition getQPropertyDefinition(Name[] parentNodeTypeNames, Name name, int type) throws ConstraintViolationException, NoSuchNodeTypeException {
        EffectiveNodeType ent = this.entProvider.getEffectiveNodeType(parentNodeTypeNames);
        return ItemDefinitionProviderImpl.getQPropertyDefinition(ent, name, type);
    }

    private EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
        if (ntName != null) {
            return this.entProvider.getEffectiveNodeType(ntName);
        }
        return null;
    }

    static QNodeDefinition getQNodeDefinition(EffectiveNodeType ent, EffectiveNodeType entTarget, Name name) throws ConstraintViolationException {
        QNodeDefinition[] defs = ent.getNamedQNodeDefinitions(name);
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                QNodeDefinition nd = defs[i];
                if (!(entTarget != null && nd.getRequiredPrimaryTypes() != null ? entTarget.includesNodeTypes(nd.getRequiredPrimaryTypes()) : nd.getDefaultPrimaryType() != null)) continue;
                return nd;
            }
        }
        QNodeDefinition[] nda = ent.getUnnamedQNodeDefinitions();
        for (int i = 0; i < nda.length; ++i) {
            QNodeDefinition nd = nda[i];
            if (!(entTarget != null && nd.getRequiredPrimaryTypes() != null ? entTarget.includesNodeTypes(nd.getRequiredPrimaryTypes()) : nd.getDefaultPrimaryType() != null)) continue;
            return nd;
        }
        throw new ConstraintViolationException("no matching child node definition found for " + String.valueOf(name));
    }

    private static QPropertyDefinition getQPropertyDefinition(EffectiveNodeType ent, Name name, int type, boolean multiValued, boolean throwWhenAmbiguous) throws ConstraintViolationException {
        QPropertyDefinition[] defs = ent.getNamedQPropertyDefinitions(name);
        QPropertyDefinition match = ItemDefinitionProviderImpl.getMatchingPropDef(defs, type, multiValued, throwWhenAmbiguous);
        if (match != null) {
            return match;
        }
        defs = ent.getUnnamedQPropertyDefinitions();
        match = ItemDefinitionProviderImpl.getMatchingPropDef(defs, type, multiValued, throwWhenAmbiguous);
        if (match != null) {
            return match;
        }
        throw new ConstraintViolationException("no matching property definition found for " + String.valueOf(name));
    }

    private static QPropertyDefinition getQPropertyDefinition(EffectiveNodeType ent, Name name, int type) throws ConstraintViolationException {
        QPropertyDefinition[] defs = ent.getNamedQPropertyDefinitions(name);
        QPropertyDefinition match = ItemDefinitionProviderImpl.getMatchingPropDef(defs, type);
        if (match != null) {
            return match;
        }
        defs = ent.getUnnamedQPropertyDefinitions();
        match = ItemDefinitionProviderImpl.getMatchingPropDef(defs, type);
        if (match != null) {
            return match;
        }
        throw new ConstraintViolationException("no matching property definition found for " + String.valueOf(name));
    }

    private static QPropertyDefinition getMatchingPropDef(QPropertyDefinition[] defs, int type) {
        QPropertyDefinition match = null;
        for (int i = 0; i < defs.length; ++i) {
            QPropertyDefinition pd;
            int reqType;
            QPropertyDefinition qDef = defs[i];
            if (qDef.definesNode() || (reqType = (pd = qDef).getRequiredType()) != 0 && type != 0 && reqType != type) continue;
            if (match == null) {
                match = pd;
            } else if (match.getRequiredType() != pd.getRequiredType()) {
                if (match.getRequiredType() == 0) {
                    match = pd;
                }
            } else if (match.isMultiple() && !pd.isMultiple()) {
                match = pd;
            }
            if (match.getRequiredType() == 0 || match.isMultiple()) continue;
            return match;
        }
        return match;
    }

    private static QPropertyDefinition getMatchingPropDef(QPropertyDefinition[] defs, int type, boolean multiValued, boolean throwWhenAmbiguous) throws ConstraintViolationException {
        QPropertyDefinition match = null;
        for (int i = 0; i < defs.length; ++i) {
            QPropertyDefinition pd;
            int reqType;
            QPropertyDefinition qDef = defs[i];
            if (qDef.definesNode() || (reqType = (pd = qDef).getRequiredType()) != 0 && type != 0 && reqType != type || multiValued != pd.isMultiple()) continue;
            if (pd.getRequiredType() != 0) {
                if (match != null && throwWhenAmbiguous) {
                    throw new ConstraintViolationException("ambiguous property definitions found: " + String.valueOf(match) + " vs " + String.valueOf(pd));
                }
                if (match != null && match.getRequiredType() == 1) continue;
                match = pd;
                continue;
            }
            if (match != null) continue;
            match = pd;
        }
        return match;
    }

    private static QNodeDefinition getNodeDefinition(RepositoryService service, SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        try {
            return service.getNodeDefinition(sessionInfo, nodeId);
        }
        catch (RepositoryException e) {
            log.error("Cannot determine node definition of {}: {}", (Object)nodeId, (Object)e);
            throw e;
        }
    }

    private static QPropertyDefinition getPropertyDefinition(RepositoryService service, SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        try {
            return service.getPropertyDefinition(sessionInfo, propertyId);
        }
        catch (RepositoryException e) {
            log.error("Cannot determine property definition of {}: {}", (Object)propertyId, (Object)e);
            throw e;
        }
    }
}

