/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.MessageProperties;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.blob.api.BlobId;
import org.apache.james.core.Username;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.cassandra.DeleteMessageListener;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.metadata.DeletedMessageVaultDeletionCallback;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.AcknowledgableDelivery;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ConsumeOptions;
import reactor.rabbitmq.ExchangeSpecification;
import reactor.rabbitmq.OutboundMessage;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.Sender;

public class DistributedDeletedMessageVaultDeletionCallback
implements DeleteMessageListener.DeletionCallback,
Startable {
    public static final Logger LOGGER = LoggerFactory.getLogger(DistributedDeletedMessageVaultDeletionCallback.class);
    private static final String EXCHANGE = "deleted-message-vault";
    private static final String QUEUE = "deleted-message-vault-work-queue";
    private static final String DEAD_LETTER = "deleted-message-vault-work-queue-dead-letter";
    private static final boolean REQUEUE = true;
    private static final int QOS = 5;
    private final ReactorRabbitMQChannelPool channelPool;
    private final RabbitMQConfiguration rabbitMQConfiguration;
    private final DeletedMessageVaultDeletionCallback callback;
    private final Sender sender;
    private final ObjectMapper objectMapper;
    private final MailboxId.Factory mailboxIdFactory;
    private final MessageId.Factory messageIdFactory;
    private final BlobId.Factory blobIdFactory;
    private final ReceiverProvider receiverProvider;
    private Disposable disposable;

    @Inject
    public DistributedDeletedMessageVaultDeletionCallback(Sender sender, ReactorRabbitMQChannelPool channelPool, RabbitMQConfiguration rabbitMQConfiguration, DeletedMessageVaultDeletionCallback callback, MailboxId.Factory mailboxIdFactory, MessageId.Factory messageIdFactory, BlobId.Factory blobIdFactory, ReceiverProvider receiverProvider) {
        this.sender = sender;
        this.rabbitMQConfiguration = rabbitMQConfiguration;
        this.callback = callback;
        this.mailboxIdFactory = mailboxIdFactory;
        this.messageIdFactory = messageIdFactory;
        this.blobIdFactory = blobIdFactory;
        this.objectMapper = new ObjectMapper();
        this.channelPool = channelPool;
        this.receiverProvider = receiverProvider;
    }

    public void init() {
        Flux.concat((Publisher[])new Publisher[]{this.sender.declareExchange(ExchangeSpecification.exchange((String)EXCHANGE).durable(true).type("direct")), this.sender.declareQueue(QueueSpecification.queue((String)DEAD_LETTER).durable(true).exclusive(false).autoDelete(false).arguments((Map)this.rabbitMQConfiguration.workQueueArgumentsBuilder().deadLetter(DEAD_LETTER).build())), this.sender.declareQueue(QueueSpecification.queue((String)QUEUE).durable(true).exclusive(false).autoDelete(false).arguments((Map)this.rabbitMQConfiguration.workQueueArgumentsBuilder().deadLetter(DEAD_LETTER).build())), this.sender.bind(BindingSpecification.binding().exchange(EXCHANGE).queue(QUEUE).routingKey(""))}).then().block();
        this.disposable = this.consumeDeletedMessageVaultWorkQueue();
    }

    private Disposable consumeDeletedMessageVaultWorkQueue() {
        return Flux.using(() -> ((ReceiverProvider)this.receiverProvider).createReceiver(), receiver -> receiver.consumeManualAck(QUEUE, new ConsumeOptions().qos(5)), Receiver::close).flatMap(this::handleMessage, 5).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }

    public void restart() {
        Disposable previousConsumer = this.disposable;
        this.disposable = this.consumeDeletedMessageVaultWorkQueue();
        previousConsumer.dispose();
    }

    @PreDestroy
    public void stop() {
        Optional.ofNullable(this.disposable).ifPresent(Disposable::dispose);
    }

    private Mono<Void> handleMessage(AcknowledgableDelivery delivery) {
        try {
            CopyCommandDTO copyCommandDTO = (CopyCommandDTO)this.objectMapper.readValue(delivery.getBody(), CopyCommandDTO.class);
            return this.callback.forMessage(copyCommandDTO.asPojo(this.mailboxIdFactory, this.messageIdFactory, this.blobIdFactory)).timeout(Duration.ofMinutes(5L)).onErrorResume(e -> {
                LOGGER.error("Failed executing deletion callback for {}", (Object)copyCommandDTO.messageId, e);
                delivery.nack(true);
                return Mono.empty();
            }).doOnSuccess(any -> delivery.ack()).doOnCancel(() -> delivery.nack(true));
        }
        catch (Exception e2) {
            LOGGER.error("Deserialization error: reject poisonous message for distributed Deleted message vault callback", (Throwable)e2);
            delivery.nack(false);
            return Mono.empty();
        }
    }

    public Mono<Void> forMessage(DeleteMessageListener.DeletedMessageCopyCommand command) {
        CopyCommandDTO dto = CopyCommandDTO.of(command);
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes((Object)dto);
            return this.sender.send((Publisher)Mono.just((Object)new OutboundMessage(EXCHANGE, "", new AMQP.BasicProperties.Builder().deliveryMode(MessageProperties.PERSISTENT_TEXT_PLAIN.getDeliveryMode()).priority(MessageProperties.PERSISTENT_TEXT_PLAIN.getPriority()).contentType(MessageProperties.PERSISTENT_TEXT_PLAIN.getContentType()).build(), bytes)));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
    }

    private static class CopyCommandDTO {
        private final String messageId;
        private final String mailboxId;
        private final String owner;
        private final Date internalDate;
        private final long size;
        private final boolean hasAttachments;
        private final String headerId;
        private final String bodyId;

        public static CopyCommandDTO of(DeleteMessageListener.DeletedMessageCopyCommand command) {
            return new CopyCommandDTO(command.getMessageId().serialize(), command.getMailboxId().serialize(), command.getOwner().asString(), command.getInternalDate(), command.getSize(), command.hasAttachments(), command.getHeaderId().asString(), command.getBodyId().asString());
        }

        @JsonCreator
        public CopyCommandDTO(@JsonProperty(value="messageId") String messageId, @JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="owner") String owner, @JsonProperty(value="internalDate") Date internalDate, @JsonProperty(value="size") long size, @JsonProperty(value="hasAttachments") boolean hasAttachments, @JsonProperty(value="headerId") String headerId, @JsonProperty(value="bodyId") String bodyId) {
            this.messageId = messageId;
            this.mailboxId = mailboxId;
            this.owner = owner;
            this.internalDate = internalDate;
            this.size = size;
            this.hasAttachments = hasAttachments;
            this.headerId = headerId;
            this.bodyId = bodyId;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getMailboxId() {
            return this.mailboxId;
        }

        public String getOwner() {
            return this.owner;
        }

        public Date getInternalDate() {
            return this.internalDate;
        }

        public long getSize() {
            return this.size;
        }

        public boolean isHasAttachments() {
            return this.hasAttachments;
        }

        public String getHeaderId() {
            return this.headerId;
        }

        public String getBodyId() {
            return this.bodyId;
        }

        @JsonIgnore
        DeleteMessageListener.DeletedMessageCopyCommand asPojo(MailboxId.Factory mailboxIdFactory, MessageId.Factory messageIdFactory, BlobId.Factory blobIdFactory) {
            return new DeleteMessageListener.DeletedMessageCopyCommand(messageIdFactory.fromString(this.messageId), mailboxIdFactory.fromString(this.messageId), Username.of((String)this.owner), this.internalDate, this.size, this.hasAttachments, blobIdFactory.parse(this.headerId), blobIdFactory.parse(this.bodyId));
        }
    }
}

