/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.postgres;

import jakarta.inject.Inject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.james.backends.postgres.utils.PostgresUtils;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.sieve.postgres.PostgresSieveQuotaDAO;
import org.apache.james.sieve.postgres.PostgresSieveScriptDAO;
import org.apache.james.sieve.postgres.model.PostgresSieveScript;
import org.apache.james.sieve.postgres.model.PostgresSieveScriptId;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresSieveRepository
implements SieveRepository {
    private final PostgresSieveQuotaDAO postgresSieveQuotaDAO;
    private final PostgresSieveScriptDAO postgresSieveScriptDAO;

    @Inject
    public PostgresSieveRepository(PostgresSieveQuotaDAO postgresSieveQuotaDAO, PostgresSieveScriptDAO postgresSieveScriptDAO) {
        this.postgresSieveQuotaDAO = postgresSieveQuotaDAO;
        this.postgresSieveScriptDAO = postgresSieveScriptDAO;
    }

    public void haveSpace(Username username, ScriptName name, long size) throws QuotaExceededException {
        long sizeDifference = (Long)this.spaceThatWillBeUsedByNewScript(username, name, size).block();
        this.throwOnOverQuota(username, sizeDifference);
    }

    public void putScript(Username username, ScriptName name, ScriptContent content) throws QuotaExceededException {
        long sizeDifference = (Long)this.spaceThatWillBeUsedByNewScript(username, name, content.length()).block();
        this.throwOnOverQuota(username, sizeDifference);
        this.postgresSieveScriptDAO.upsertScript(PostgresSieveScript.builder().username(username.asString()).scriptName(name.getValue()).scriptContent(content.getValue()).scriptSize(content.length()).isActive(false).id(PostgresSieveScriptId.generate()).build()).flatMap(upsertedScripts -> {
            if (upsertedScripts > 0) {
                return this.updateSpaceUsed(username, sizeDifference);
            }
            return Mono.empty();
        }).block();
    }

    private Mono<Void> updateSpaceUsed(Username username, long spaceToUse) {
        if (spaceToUse == 0L) {
            return Mono.empty();
        }
        return this.postgresSieveQuotaDAO.updateSpaceUsed(username, spaceToUse);
    }

    private Mono<Long> spaceThatWillBeUsedByNewScript(Username username, ScriptName name, long scriptSize) {
        return this.postgresSieveScriptDAO.getScriptSize(username, name).defaultIfEmpty((Object)0L).map(sizeOfStoredScript -> scriptSize - sizeOfStoredScript);
    }

    private void throwOnOverQuota(Username username, Long sizeDifference) throws QuotaExceededException {
        long spaceUsed = (Long)this.postgresSieveQuotaDAO.spaceUsedBy(username).block();
        QuotaSizeLimit limit = (QuotaSizeLimit)this.limitToUser(username).block();
        if (QuotaSizeUsage.size((long)spaceUsed).add(sizeDifference.longValue()).exceedLimit(limit)) {
            throw new QuotaExceededException();
        }
    }

    private Mono<QuotaSizeLimit> limitToUser(Username username) {
        return this.postgresSieveQuotaDAO.getQuota(username).filter(Optional::isPresent).switchIfEmpty(this.postgresSieveQuotaDAO.getGlobalQuota()).map(optional -> optional.orElse(QuotaSizeLimit.unlimited()));
    }

    public List<ScriptSummary> listScripts(Username username) {
        return (List)this.listScriptsReactive(username).collectList().block();
    }

    public Flux<ScriptSummary> listScriptsReactive(Username username) {
        return this.postgresSieveScriptDAO.getScripts(username).map(PostgresSieveScript::toScriptSummary);
    }

    public ZonedDateTime getActivationDateForActiveScript(Username username) throws ScriptNotFoundException {
        return ((PostgresSieveScript)this.postgresSieveScriptDAO.getActiveScript(username).blockOptional().orElseThrow(ScriptNotFoundException::new)).getActivationDateTime().toZonedDateTime();
    }

    public InputStream getActive(Username username) throws ScriptNotFoundException {
        return IOUtils.toInputStream((String)((PostgresSieveScript)this.postgresSieveScriptDAO.getActiveScript(username).blockOptional().orElseThrow(ScriptNotFoundException::new)).getScriptContent(), (Charset)StandardCharsets.UTF_8);
    }

    public void setActive(Username username, ScriptName name) throws ScriptNotFoundException {
        if (SieveRepository.NO_SCRIPT_NAME.equals((Object)name)) {
            this.switchOffCurrentActiveScript(username);
        } else {
            this.throwOnScriptNonExistence(username, name);
            this.switchOffCurrentActiveScript(username);
            this.activateScript(username, name);
        }
    }

    private void throwOnScriptNonExistence(Username username, ScriptName name) throws ScriptNotFoundException {
        if (!((Boolean)this.postgresSieveScriptDAO.scriptExists(username, name).block()).booleanValue()) {
            throw new ScriptNotFoundException();
        }
    }

    private void switchOffCurrentActiveScript(Username username) {
        this.postgresSieveScriptDAO.deactivateCurrentActiveScript(username).block();
    }

    private void activateScript(Username username, ScriptName scriptName) {
        this.postgresSieveScriptDAO.activateScript(username, scriptName).block();
    }

    public InputStream getScript(Username username, ScriptName name) throws ScriptNotFoundException {
        return IOUtils.toInputStream((String)((PostgresSieveScript)this.postgresSieveScriptDAO.getScript(username, name).blockOptional().orElseThrow(ScriptNotFoundException::new)).getScriptContent(), (Charset)StandardCharsets.UTF_8);
    }

    public void deleteScript(Username username, ScriptName name) throws ScriptNotFoundException, IsActiveException {
        boolean isActive = (Boolean)this.postgresSieveScriptDAO.getIsActive(username, name).blockOptional().orElseThrow(ScriptNotFoundException::new);
        if (isActive) {
            throw new IsActiveException();
        }
        this.postgresSieveScriptDAO.deleteScript(username, name).block();
    }

    public void renameScript(Username username, ScriptName oldName, ScriptName newName) throws DuplicateException, ScriptNotFoundException {
        try {
            int renamedScripts = (Integer)this.postgresSieveScriptDAO.renameScript(username, oldName, newName).block();
            if (renamedScripts == 0) {
                throw new ScriptNotFoundException();
            }
        }
        catch (Exception e) {
            if (PostgresUtils.UNIQUE_CONSTRAINT_VIOLATION_PREDICATE.test(e)) {
                throw new DuplicateException();
            }
            throw e;
        }
    }

    public boolean hasDefaultQuota() {
        return ((Optional)this.postgresSieveQuotaDAO.getGlobalQuota().block()).isPresent();
    }

    public QuotaSizeLimit getDefaultQuota() throws QuotaNotFoundException {
        return (QuotaSizeLimit)((Optional)this.postgresSieveQuotaDAO.getGlobalQuota().block()).orElseThrow(() -> new QuotaNotFoundException("Unable to find quota for default user"));
    }

    public void setDefaultQuota(QuotaSizeLimit quota) {
        this.postgresSieveQuotaDAO.setGlobalQuota(quota).block();
    }

    public void removeQuota() {
        this.postgresSieveQuotaDAO.removeGlobalQuota().block();
    }

    public boolean hasQuota(Username username) {
        Mono hasUserQuota = this.postgresSieveQuotaDAO.getQuota(username).map(Optional::isPresent);
        Mono hasGlobalQuota = this.postgresSieveQuotaDAO.getGlobalQuota().map(Optional::isPresent);
        return (Boolean)hasUserQuota.zipWith(hasGlobalQuota, (a, b) -> a != false || b != false).block();
    }

    public QuotaSizeLimit getQuota(Username username) throws QuotaNotFoundException {
        return (QuotaSizeLimit)((Optional)this.postgresSieveQuotaDAO.getQuota(username).block()).orElseThrow(() -> new QuotaNotFoundException("Unable to find quota for user " + username.asString()));
    }

    public void setQuota(Username username, QuotaSizeLimit quota) {
        this.postgresSieveQuotaDAO.setQuota(username, quota).block();
    }

    public void removeQuota(Username username) {
        this.postgresSieveQuotaDAO.removeQuota(username).block();
    }

    public Mono<Void> resetSpaceUsedReactive(Username username, long spaceUsed) {
        return Mono.error((Throwable)new UnsupportedOperationException());
    }
}

