/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.unboundidds.extensions.ChangelogBatchStartingPoint;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ResumeWithCSNStartingPoint
extends ChangelogBatchStartingPoint {
    static final byte TYPE = -127;
    private static final long serialVersionUID = -5205334877324505765L;
    @NotNull
    private final String csn;

    public ResumeWithCSNStartingPoint(@NotNull String csn) {
        Validator.ensureNotNull(csn);
        this.csn = csn;
    }

    @NotNull
    public String getCSN() {
        return this.csn;
    }

    @Override
    @NotNull
    public ASN1Element encode() {
        return new ASN1OctetString(-127, this.csn);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ResumeWithCSNStartingPoint(csn='");
        buffer.append(this.csn);
        buffer.append("')");
    }
}

