/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.json;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.json.ValidationAction;
import org.apache.jena.fuseki.validation.json.ValidatorJsonLib;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryValidatorJSON {
    static final String paramQuery = "query";
    static final String paramSyntax = "languageSyntax";
    static final String jInput = "input";
    static final String jFormatted = "formatted";
    static final String jAlgebra = "algebra";
    static final String jAlgebraQuads = "algebra-quads";
    static final String jAlgebraOpt = "algebra-opt";
    static final String jAlgebraOptQuads = "algebra-opt-quads";

    public static JsonObject execute(ValidationAction action) {
        Syntax language;
        JsonBuilder obj = new JsonBuilder();
        obj.startObject();
        String queryString = ValidatorJsonLib.getArg(action, paramQuery);
        String querySyntax = ValidatorJsonLib.getArgOrNull(action, paramSyntax);
        if (querySyntax == null || querySyntax.equals("")) {
            querySyntax = "SPARQL";
        }
        if ((language = Syntax.lookup(querySyntax)) == null) {
            ServletOps.errorBadRequest("Unknown syntax: " + querySyntax);
            return null;
        }
        boolean outputSPARQL = true;
        boolean outputAlgebra = true;
        boolean outputQuads = true;
        boolean outputOptimized = true;
        boolean outputOptimizedQuads = true;
        obj.key(jInput).value(queryString);
        Query query2 = null;
        try {
            query2 = QueryFactory.create(queryString, "http://example/base/", language);
        }
        catch (QueryParseException ex) {
            obj.key("errors");
            obj.startArray();
            obj.startObject();
            obj.key("parse-error").value(ex.getMessage());
            obj.key("parse-error-line").value(ex.getLine());
            obj.key("parse-error-column").value(ex.getColumn());
            obj.finishObject();
            obj.finishArray();
            obj.finishObject();
            return obj.build().getAsObject();
        }
        if (query2 != null) {
            if (outputSPARQL) {
                QueryValidatorJSON.formatted(obj, query2);
            }
            if (outputAlgebra) {
                QueryValidatorJSON.algebra(obj, query2);
            }
            if (outputQuads) {
                QueryValidatorJSON.algebraQuads(obj, query2);
            }
            if (outputOptimized) {
                QueryValidatorJSON.algebraOpt(obj, query2);
            }
            if (outputOptimizedQuads) {
                QueryValidatorJSON.algebraOptQuads(obj, query2);
            }
        }
        obj.finishObject();
        return obj.build().getAsObject();
    }

    private static void formatted(JsonBuilder obj, Query query2) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        query2.serialize(out);
        obj.key(jFormatted).value(out.asString());
    }

    private static void algebra(JsonBuilder obj, Query query2) {
        Op op = Algebra.compile(query2);
        obj.key(jAlgebra).value(QueryValidatorJSON.string(query2, op));
    }

    private static void algebraQuads(JsonBuilder obj, Query query2) {
        Op op = Algebra.compile(query2);
        op = Algebra.toQuadForm(op);
        obj.key(jAlgebraQuads).value(QueryValidatorJSON.string(query2, op));
    }

    private static void algebraOpt(JsonBuilder obj, Query query2) {
        Op op = Algebra.compile(query2);
        op = Algebra.optimize(op);
        obj.key(jAlgebraOpt).value(QueryValidatorJSON.string(query2, op));
    }

    private static void algebraOptQuads(JsonBuilder obj, Query query2) {
        Op op = Algebra.compile(query2);
        op = Algebra.toQuadForm(op);
        op = Algebra.optimize(op);
        obj.key(jAlgebraOptQuads).value(QueryValidatorJSON.string(query2, op));
    }

    private static String string(Query query2, Op op) {
        SerializationContext sCxt = new SerializationContext(query2);
        IndentedLineBuffer out = new IndentedLineBuffer();
        op.output(out, sCxt);
        return out.asString();
    }
}

