/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.util.TextUtil;

public class WikiBootstrapServletContextListener
implements ServletContextListener {
    private static final Logger LOG = LogManager.getLogger(WikiBootstrapServletContextListener.class);
    private static final String[] LOG4J_CONF = new String[]{"appender", "logger", "rootLogger", "filter", "status", "dest", "name", "properties", "property", "log4j2"};

    public void contextInitialized(ServletContextEvent sce) {
        Properties properties = this.initWikiSPIs(sce);
        this.initWikiLoggingFramework(properties);
    }

    Properties initWikiSPIs(ServletContextEvent sce) {
        return Wiki.init((ServletContext)sce.getServletContext());
    }

    boolean initWikiLoggingFramework(Properties properties) {
        ConfigurationSource source;
        String useExternalLogConfig = TextUtil.getStringProperty((Properties)properties, (String)"jspwiki.use.external.logconfig", (String)"false");
        if (useExternalLogConfig.equals("false") && (source = this.createConfigurationSource(properties)) != null) {
            PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory();
            LoggerContext ctx = (LoggerContext)LogManager.getContext((ClassLoader)this.getClass().getClassLoader(), (boolean)false);
            PropertiesConfiguration conf = factory.getConfiguration(ctx, source);
            conf.initialize();
            ctx.setConfiguration((Configuration)conf);
            LOG.info("Log configuration reloaded from Wiki properties");
        }
        return useExternalLogConfig.equals("false");
    }

    ConfigurationSource createConfigurationSource(Properties properties) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Properties log4JProperties = new Properties();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                for (String log4JNsProp : LOG4J_CONF) {
                    if (!k.toString().startsWith(log4JNsProp)) continue;
                    log4JProperties.put(k, v);
                }
            }));
            log4JProperties.store(out, null);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            return new ConfigurationSource((InputStream)in);
        }
        catch (IOException ioe) {
            LOG.error("Unable to load the properties file into Log4j2, default Log4J2 configuration will be applied.", (Throwable)ioe);
            return null;
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

