/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.List;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedClassMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfMetaProvider;
import org.apache.juneau.jena.RdfUtils;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.jena.annotation.RdfSchema;
import org.apache.juneau.xml.Namespace;

public class RdfClassMeta
extends ExtendedClassMeta {
    private final Rdf rdf;
    private final RdfCollectionFormat collectionFormat;
    private final Namespace namespace;

    public RdfClassMeta(ClassMeta<?> cm, RdfMetaProvider mp) {
        super(cm);
        this.rdf = (Rdf)cm.getAnnotation(Rdf.class);
        this.collectionFormat = this.rdf != null ? this.rdf.collectionFormat() : RdfCollectionFormat.DEFAULT;
        List rdfs = cm.getAnnotations(Rdf.class);
        List schemas = cm.getAnnotations(RdfSchema.class);
        this.namespace = RdfUtils.findNamespace(rdfs, schemas);
    }

    protected Rdf getAnnotation() {
        return this.rdf;
    }

    protected RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    protected Namespace getNamespace() {
        return this.namespace;
    }
}

