/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.NoCloseWriter;

public class TeeWriter
extends Writer {
    private Writer[] writers = new Writer[0];
    private Map<String, Writer> writerMap;

    public TeeWriter(Writer ... writers) {
        this.writers = writers;
    }

    public TeeWriter(Collection<Writer> writers) {
        this.writers = writers.toArray(new Writer[writers.size()]);
    }

    public TeeWriter add(Writer w, boolean close) {
        if (w == null) {
            return this;
        }
        if (!close) {
            w = new NoCloseWriter(w);
        }
        if (w == this) {
            throw new RuntimeException("Cannot add this writer to itself.");
        }
        for (Writer w2 : this.writers) {
            if (w2 != w) continue;
            throw new RuntimeException("Cannot add this writer again.");
        }
        if (w instanceof TeeWriter) {
            for (Writer w2 : ((TeeWriter)w).writers) {
                this.add(w2, true);
            }
        } else {
            this.writers = ArrayUtils.append(this.writers, w);
        }
        return this;
    }

    public TeeWriter add(String id, Writer w, boolean close) {
        if (id != null) {
            if (this.writerMap == null) {
                this.writerMap = new TreeMap<String, Writer>();
            }
            this.writerMap.put(id, w);
        }
        return this.add(w, close);
    }

    public int size() {
        return this.writers.length;
    }

    public Writer getWriter(String id) {
        if (this.writerMap != null) {
            return this.writerMap.get(id);
        }
        return null;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (Writer w : this.writers) {
            if (w == null) continue;
            w.write(cbuf, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (Writer w : this.writers) {
            if (w == null) continue;
            w.flush();
        }
    }

    @Override
    public void close() throws IOException {
        IOException e = null;
        for (Writer w : this.writers) {
            if (w == null) continue;
            try {
                w.close();
            }
            catch (IOException e2) {
                e = e2;
            }
        }
        if (e != null) {
            throw e;
        }
    }
}

