/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.json.JsonBeanPropertyMeta;
import org.apache.juneau.json.JsonClassMeta;
import org.apache.juneau.json.JsonCommon;
import org.apache.juneau.json.JsonMetaProvider;
import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.json.JsonSerializerBuilder;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;

@ConfigurableContext
public class JsonSerializer
extends WriterSerializer
implements JsonMetaProvider,
JsonCommon {
    static final String PREFIX = "JsonSerializer";
    public static final String JSON_addBeanTypes = "JsonSerializer.addBeanTypes.b";
    public static final String JSON_escapeSolidus = "JsonSerializer.escapeSolidus.b";
    public static final String JSON_simpleMode = "JsonSerializer.simpleMode.b";
    public static final JsonSerializer DEFAULT = new JsonSerializer(PropertyStore.DEFAULT);
    public static final JsonSerializer DEFAULT_READABLE = new Readable(PropertyStore.DEFAULT);
    private final boolean simpleMode;
    private final boolean escapeSolidus;
    private final boolean addBeanTypes;
    private final Map<ClassMeta<?>, JsonClassMeta> jsonClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, JsonBeanPropertyMeta> jsonBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, JsonBeanPropertyMeta>();
    private volatile JsonSchemaSerializer schemaSerializer;

    public JsonSerializer(PropertyStore ps) {
        this(ps, "application/json", "application/json,text/json");
    }

    public JsonSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.simpleMode = this.getBooleanProperty(JSON_simpleMode, false);
        this.escapeSolidus = this.getBooleanProperty(JSON_escapeSolidus, false);
        this.addBeanTypes = this.getBooleanProperty(JSON_addBeanTypes, this.getBooleanProperty("Serializer.addBeanTypes.b", false));
    }

    @Override
    public JsonSerializerBuilder builder() {
        return new JsonSerializerBuilder(this.getPropertyStore());
    }

    public static JsonSerializerBuilder create() {
        return new JsonSerializerBuilder();
    }

    public JsonSchemaSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = this.builder().build(JsonSchemaSerializer.class);
        }
        return this.schemaSerializer;
    }

    @Override
    public JsonSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public JsonSerializerSession createSession(SerializerSessionArgs args) {
        return new JsonSerializerSession(this, args);
    }

    @Override
    public JsonClassMeta getJsonClassMeta(ClassMeta<?> cm) {
        JsonClassMeta m = this.jsonClassMetas.get(cm);
        if (m == null) {
            m = new JsonClassMeta(cm, this);
            this.jsonClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public JsonBeanPropertyMeta getJsonBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return JsonBeanPropertyMeta.DEFAULT;
        }
        JsonBeanPropertyMeta m = this.jsonBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new JsonBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.jsonBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isEscapeSolidus() {
        return this.escapeSolidus;
    }

    protected final boolean isSimpleMode() {
        return this.simpleMode;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("simpleMode", this.simpleMode).append("escapeSolidus", this.escapeSolidus).append("addBeanTypes", this.addBeanTypes));
    }

    public static class ReadableSafe
    extends JsonSerializer {
        public ReadableSafe(PropertyStore ps) {
            super(ps.builder().set(JsonSerializer.JSON_simpleMode, true).set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("WriterSerializer.useWhitespace.b", true).set("BeanTraverseContext.detectRecursions.b", true).build());
        }
    }

    public static class Readable
    extends JsonSerializer {
        public Readable(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.useWhitespace.b", true).build());
        }
    }
}

