/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletInputStream;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.ContentType;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.exception.BadRequest;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.http.exception.UnsupportedMediaType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.CharSequenceReader;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RequestHeaders;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.util.BoundedServletInputStream;

public class RequestBody {
    private byte[] body;
    private final RestRequest req;
    private EncoderGroup encoders;
    private Encoder encoder;
    private ParserGroup parsers;
    private long maxInput;
    private RequestHeaders headers;
    private int contentLength = 0;
    private MediaType mediaType;
    private Parser parser;
    private HttpPartSchema schema;

    RequestBody(RestRequest req) {
        this.req = req;
    }

    RequestBody encoders(EncoderGroup encoders) {
        this.encoders = encoders;
        return this;
    }

    RequestBody parsers(ParserGroup parsers) {
        this.parsers = parsers;
        return this;
    }

    RequestBody schema(HttpPartSchema schema) {
        this.schema = schema;
        return this;
    }

    RequestBody headers(RequestHeaders headers) {
        this.headers = headers;
        return this;
    }

    RequestBody maxInput(long maxInput) {
        this.maxInput = maxInput;
        return this;
    }

    RequestBody load(MediaType mediaType, Parser parser, byte[] body) {
        this.mediaType = mediaType;
        this.parser = parser;
        this.body = body;
        return this;
    }

    boolean isLoaded() {
        return this.body != null;
    }

    public <T> T asType(Class<T> type) throws BadRequest, UnsupportedMediaType, InternalServerError {
        return this.getInner(this.getClassMeta(type));
    }

    public <T> T asType(Type type, Type ... args) throws BadRequest, UnsupportedMediaType, InternalServerError {
        return this.getInner(this.getClassMeta(type, args));
    }

    public String asString() throws IOException {
        if (this.body == null) {
            this.body = IOUtils.readBytes((InputStream)this.getInputStream(), 1024);
        }
        return new String(this.body, IOUtils.UTF8);
    }

    public String asHex() throws IOException {
        if (this.body == null) {
            this.body = IOUtils.readBytes((InputStream)this.getInputStream(), 1024);
        }
        return StringUtils.toHex(this.body);
    }

    public String asSpacedHex() throws IOException {
        if (this.body == null) {
            this.body = IOUtils.readBytes((InputStream)this.getInputStream(), 1024);
        }
        return StringUtils.toSpacedHex(this.body);
    }

    public BufferedReader getReader() throws IOException {
        Reader r = this.getUnbufferedReader();
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        int len = this.req.getContentLength();
        int buffSize = len <= 0 ? 8192 : Math.max(len, 8192);
        return new BufferedReader(r, buffSize);
    }

    protected Reader getUnbufferedReader() throws IOException {
        if (this.body != null) {
            return new CharSequenceReader(new String(this.body, IOUtils.UTF8));
        }
        return new InputStreamReader((InputStream)this.getInputStream(), this.req.getCharacterEncoding());
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.body != null) {
            return new BoundedServletInputStream(this.body);
        }
        Encoder enc = this.getEncoder();
        if (enc == null) {
            return new BoundedServletInputStream(this.req.getRawInputStream(), this.maxInput);
        }
        return new BoundedServletInputStream(enc.getInputStream((InputStream)this.req.getRawInputStream()), this.maxInput);
    }

    public ParserMatch getParserMatch() {
        if (this.mediaType != null && this.parser != null) {
            return new ParserMatch(this.mediaType, this.parser);
        }
        MediaType mt = this.getMediaType();
        return mt == null ? null : this.parsers.getParserMatch(mt);
    }

    private MediaType getMediaType() {
        if (this.mediaType != null) {
            return this.mediaType;
        }
        ContentType mediaType = this.headers.getContentType();
        if (mediaType == null && this.body != null) {
            return MediaType.UON;
        }
        return mediaType;
    }

    public Parser getParser() {
        ParserMatch pm = this.getParserMatch();
        return pm == null ? null : pm.getParser();
    }

    public ReaderParser getReaderParser() {
        Parser p = this.getParser();
        if (p != null && p.isReaderParser()) {
            return (ReaderParser)p;
        }
        return null;
    }

    public InputStreamParser getInputStreamParser() {
        Parser p = this.getParser();
        if (p != null && !p.isReaderParser()) {
            return (InputStreamParser)p;
        }
        return null;
    }

    private <T> T getInner(ClassMeta<T> cm) throws BadRequest, UnsupportedMediaType, InternalServerError {
        try {
            return this.parse(cm);
        }
        catch (UnsupportedMediaType e) {
            throw e;
        }
        catch (SchemaValidationException e) {
            throw new BadRequest("Validation failed on request body. " + e.getLocalizedMessage());
        }
        catch (ParseException e) {
            throw new BadRequest((Throwable)e, "Could not convert request body content to class type ''{0}''.", cm);
        }
        catch (IOException e) {
            throw new InternalServerError((Throwable)e, "I/O exception occurred while parsing request body.", new Object[0]);
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e, "Exception occurred while parsing request body.", new Object[0]);
        }
    }

    private <T> T parse(ClassMeta<T> cm) throws SchemaValidationException, ParseException, UnsupportedMediaType, IOException {
        if (cm.isReader()) {
            return (T)this.getReader();
        }
        if (cm.isInputStream()) {
            return (T)this.getInputStream();
        }
        TimeZone timeZone = this.headers.getTimeZone();
        Locale locale = this.req.getLocale();
        ParserMatch pm = this.getParserMatch();
        if (this.schema == null) {
            this.schema = HttpPartSchema.DEFAULT;
        }
        if (pm != null) {
            Parser p = pm.getParser();
            MediaType mediaType = pm.getMediaType();
            ParserSessionArgs pArgs = ParserSessionArgs.create().properties(this.req.getAttributes()).javaMethod(this.req.getJavaMethod()).locale(locale).timeZone(timeZone).mediaType(mediaType).streamCharset(this.req.getCharset()).schema(this.schema).debug(this.req.isDebug() ? Boolean.valueOf(true) : null).outer(this.req.getContext().getResource());
            ParserSession session = p.createSession(pArgs);
            try (Reader in = session.isReaderParser() ? this.getUnbufferedReader() : this.getInputStream();){
                T o = session.parse((Object)in, cm);
                if (this.schema != null) {
                    this.schema.validateOutput(o, cm.getBeanContext());
                }
                T t = o;
                return t;
            }
        }
        if (cm.hasReaderMutater()) {
            return cm.getReaderMutater().mutate(this.getReader());
        }
        if (cm.hasInputStreamMutater()) {
            return cm.getInputStreamMutater().mutate((InputStream)this.getInputStream());
        }
        MediaType mt = this.getMediaType();
        if ((StringUtils.isEmpty(mt) || mt.toString().startsWith("text/plain")) && cm.hasStringMutater()) {
            return cm.getStringMutater().mutate(this.asString());
        }
        throw new UnsupportedMediaType("Unsupported media-type in request header ''Content-Type'': ''{0}''\n\tSupported media-types: {1}", this.headers.getContentType(), this.req.getParsers().getSupportedMediaTypes());
    }

    private Encoder getEncoder() throws UnsupportedMediaType {
        if (this.encoder == null) {
            String ce = this.req.getHeader("content-encoding");
            if (StringUtils.isNotEmpty(ce)) {
                ce = ce.trim();
                this.encoder = this.encoders.getEncoder(ce);
                if (this.encoder == null) {
                    throw new UnsupportedMediaType("Unsupported encoding in request header ''Content-Encoding'': ''{0}''\n\tSupported codings: {1}", this.req.getHeader("content-encoding"), this.encoders.getSupportedEncodings());
                }
            }
            if (this.encoder != null) {
                this.contentLength = -1;
            }
        }
        if (this.encoder == IdentityEncoder.INSTANCE) {
            return null;
        }
        return this.encoder;
    }

    public int getContentLength() {
        return this.contentLength == 0 ? this.req.getRawContentLength() : this.contentLength;
    }

    private <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.req.getBeanSession().getClassMeta(type, args);
    }

    private <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.req.getBeanSession().getClassMeta(type);
    }
}

