/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.widget;

import java.io.IOException;
import java.util.Locale;
import org.apache.juneau.html.HtmlWidget;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.ClasspathResourceFinderRecursive;
import org.apache.juneau.utils.ClasspathResourceManager;

public abstract class Widget
implements HtmlWidget {
    private final ClasspathResourceManager rm = new ClasspathResourceManager(this.getClass(), ClasspathResourceFinderRecursive.INSTANCE, false);
    private static final String SESSION_req = "req";
    private static final String SESSION_res = "res";

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    private RestRequest req(VarResolverSession session) {
        return session.getSessionObject(RestRequest.class, SESSION_req, true);
    }

    private RestResponse res(VarResolverSession session) {
        return session.getSessionObject(RestResponse.class, SESSION_res, true);
    }

    @Override
    public String getHtml(VarResolverSession session) throws Exception {
        return this.getHtml(this.req(session), this.res(session));
    }

    @Override
    public String getScript(VarResolverSession session) throws Exception {
        return this.getScript(this.req(session), this.res(session));
    }

    @Override
    public String getStyle(VarResolverSession session) throws Exception {
        return this.getStyle(this.req(session), this.res(session));
    }

    public String getHtml(RestRequest req, RestResponse res) throws Exception {
        return null;
    }

    @Deprecated
    public String getHtml(RestRequest req) throws Exception {
        return this.getHtml(req, null);
    }

    public String getScript(RestRequest req, RestResponse res) throws Exception {
        return null;
    }

    @Deprecated
    public String getScript(RestRequest req) throws Exception {
        return this.getScript(req, null);
    }

    public String getStyle(RestRequest req, RestResponse res) throws Exception {
        return null;
    }

    @Deprecated
    public String getStyle(RestRequest req) throws Exception {
        return this.getStyle(req, null);
    }

    protected String getClasspathResourceAsString(String name) throws IOException {
        return this.rm.getString(name);
    }

    protected String getClasspathResourceAsString(String name, Locale locale) throws IOException {
        return this.rm.getString(name, locale);
    }

    protected String loadScript(String name) throws IOException {
        String s = this.getClasspathResourceAsString(name);
        if (s != null) {
            s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
        }
        return s;
    }

    protected String loadScriptWithVars(RestRequest req, RestResponse res, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadScript(name));
    }

    protected String loadStyle(String name) throws IOException {
        String s = this.getClasspathResourceAsString(name);
        if (s != null) {
            s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
        }
        return s;
    }

    protected String loadStyleWithVars(RestRequest req, RestResponse res, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadStyle(name));
    }

    protected String loadHtml(String name) throws IOException {
        String s = this.getClasspathResourceAsString(name);
        if (s != null) {
            s = s.replaceAll("(?s)<!--(.*?)-->\\s*", "");
        }
        return s;
    }

    protected String loadHtmlWithVars(RestRequest req, RestResponse res, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadHtml(name));
    }
}

