/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl.vars;

import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.svl.MultipartVar;
import org.apache.juneau.svl.VarResolverSession;

public class SubstringVar
extends MultipartVar {
    public static final String NAME = "ST";

    public SubstringVar() {
        super(NAME);
    }

    @Override
    public String resolve(VarResolverSession session, String[] args) {
        if (args.length > 3) {
            ThrowableUtils.illegalArg("Invalid number of arguments passed to $ST var.  Must have 1 or 2 arguments.", new Object[0]);
        }
        String stringArg = args[0];
        String result = "";
        if (args.length == 2) {
            int start = Integer.parseInt(args[1]);
            if (start >= 0 && start <= stringArg.length()) {
                result = stringArg.substring(start);
            }
            if (start < 0 && -start <= stringArg.length()) {
                result = stringArg.substring(stringArg.length() + start);
            }
        } else if (args.length == 3) {
            int start = Integer.parseInt(args[1]);
            int end = Integer.parseInt(args[2]);
            if (start >= 0 && start < stringArg.length() && end >= 0 && end <= stringArg.length() && start < end) {
                result = stringArg.substring(start, end);
            }
        }
        return result;
    }
}

